/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api;

import be.recipe.api.PrescriptionService;
import be.recipe.api.crypto.Cipher;
import be.recipe.api.executor.ListPrescriptions;
import be.recipe.api.patient.ListPrescriptions;
import be.recipe.api.prescriber.ListPrescriptions;
import be.recipe.api.series.PartialResult;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java8.util.function.Function;
import java8.util.function.Supplier;
import java8.util.stream.Collectors;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;

public class PrefetchingPrescriptionService
extends PrescriptionService.Ciphering.Simplified.Wrapper {
    private static final ExecutorService threadpool = Executors.newFixedThreadPool(10);

    public PrefetchingPrescriptionService(PrescriptionService.Ciphering.Simplified target) {
        super(target);
    }

    @Override
    public ListPrescriptions.PartialResult<ListPrescriptions.Response.PlainText> list(ListPrescriptions request) {
        final ListPrescriptions.PartialResult<ListPrescriptions.Response.PlainText> target = super.list(request);
        return ListPrescriptions.PartialResult.Simple.wrap(target, new Supplier<PartialResult<ListPrescriptions.Response.PlainText>>(){

            public PartialResult<ListPrescriptions.Response.PlainText> get() {
                return PartialResult.Simple.of(PrefetchedListPrescriptionsAsPrescriberItem.stream(target)).hasMore(target.hasMore());
            }
        });
    }

    @Override
    public PartialResult<ListPrescriptions.Response.PlainText> list(final be.recipe.api.executor.ListPrescriptions request) {
        return PartialResult.Simple.of(new Supplier<Stream<ListPrescriptions.Response.PlainText>>(){

            public Stream<ListPrescriptions.Response.PlainText> get() {
                return PrefetchingPrescriptionService.prefetch(PrefetchingPrescriptionService.this.target.list(request).stream(), (Function)new Function<ListPrescriptions.Response.PlainText, ListPrescriptions.Response.PlainText>(){

                    public ListPrescriptions.Response.PlainText apply(ListPrescriptions.Response.PlainText plainText) {
                        return new PrefetchedListPrescriptionsAsExecutorItem(plainText);
                    }
                });
            }
        });
    }

    @Override
    public PartialResult<ListPrescriptions.Response.PlainText> list(final be.recipe.api.patient.ListPrescriptions request) {
        return PartialResult.Simple.of(new Supplier<Stream<ListPrescriptions.Response.PlainText>>(){

            public Stream<ListPrescriptions.Response.PlainText> get() {
                return PrefetchingPrescriptionService.prefetch(PrefetchingPrescriptionService.this.target.list(request).stream(), (Function)new Function<ListPrescriptions.Response.PlainText, ListPrescriptions.Response.PlainText>(){

                    public ListPrescriptions.Response.PlainText apply(ListPrescriptions.Response.PlainText plainText) {
                        return new PrefetchedListPrescriptionsAsPatientItem(plainText);
                    }
                });
            }
        });
    }

    private static <F, T> Stream<T> prefetch(Stream<F> stream, Function<F, T> transformer) {
        return StreamSupport.stream((Collection)((List)stream.map(PrefetchingPrescriptionService.toFuture(transformer)).collect(Collectors.toList()))).map(new Function<Future<T>, T>(){

            public T apply(Future<T> future) {
                try {
                    return future.get();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static <F, T> Function<F, Future<T>> toFuture(final Function<F, T> factory) {
        return new Function<F, Future<T>>(){

            public Future<T> apply(final F prescription) {
                return threadpool.submit(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return factory.apply(prescription);
                    }
                });
            }
        };
    }

    private static class PrefetchedListPrescriptionsAsPatientItem
    extends ListPrescriptions.Response.PlainText.Wrapper {
        private String prescriptionContent = "non decipherable";
        private Cipher.Undecipherable exception;

        public PrefetchedListPrescriptionsAsPatientItem(ListPrescriptions.Response.PlainText target) {
            super(target);
            try {
                this.prescriptionContent = target.prescriptionContent();
            }
            catch (Cipher.Undecipherable e) {
                this.exception = e;
            }
        }

        @Override
        public String prescriptionContent() {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.prescriptionContent;
        }
    }

    private static class PrefetchedListPrescriptionsAsExecutorItem
    extends ListPrescriptions.Response.PlainText.Wrapper {
        private String prescriptionContent = "non decipherable";
        private Cipher.Undecipherable exception;

        public PrefetchedListPrescriptionsAsExecutorItem(ListPrescriptions.Response.PlainText target) {
            super(target);
            try {
                this.prescriptionContent = target.prescriptionContent();
            }
            catch (Cipher.Undecipherable e) {
                this.exception = e;
            }
        }

        @Override
        public String prescriptionContent() {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.prescriptionContent;
        }
    }

    private static class PrefetchedListPrescriptionsAsPrescriberItem
    extends ListPrescriptions.Response.PlainText.Wrapper {
        private String prescriptionContent = "non decipherable";
        private Cipher.Undecipherable exception;

        public PrefetchedListPrescriptionsAsPrescriberItem(ListPrescriptions.Response.PlainText target) {
            super(target);
            try {
                this.prescriptionContent = target.prescriptionContent();
            }
            catch (Cipher.Undecipherable e) {
                this.exception = e;
            }
        }

        @Override
        public String prescriptionContent() {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.prescriptionContent;
        }

        public static Supplier<Stream<PrefetchedListPrescriptionsAsPrescriberItem>> stream(final ListPrescriptions.PartialResult<ListPrescriptions.Response.PlainText> target) {
            return new Supplier<Stream<PrefetchedListPrescriptionsAsPrescriberItem>>(){

                public Stream<PrefetchedListPrescriptionsAsPrescriberItem> get() {
                    return PrefetchingPrescriptionService.prefetch(target.stream(), PrefetchedListPrescriptionsAsPrescriberItem.wrap());
                }
            };
        }

        public static Function<ListPrescriptions.Response.PlainText, PrefetchedListPrescriptionsAsPrescriberItem> wrap() {
            return new Function<ListPrescriptions.Response.PlainText, PrefetchedListPrescriptionsAsPrescriberItem>(){

                public PrefetchedListPrescriptionsAsPrescriberItem apply(ListPrescriptions.Response.PlainText plainText) {
                    return new PrefetchedListPrescriptionsAsPrescriberItem(plainText);
                }
            };
        }
    }
}

