/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api;

import be.recipe.api.executor.Executor;
import be.recipe.api.executor.GetProfile;
import be.recipe.api.patient.GetExecutorProfile;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

public interface ExecutorProfile
extends GetExecutorProfile.Response,
GetProfile.Response {
    public static final String illegal_access = "illegal.access.executor.profile";

    public Executor.ID executorId();

    @Override
    public ReservationFeature reservationFeature();

    @Override
    public CommunicationChannelSpecification communicationChannelSpecification();

    public static class Wrapper
    implements ExecutorProfile {
        private final ExecutorProfile target;

        public Wrapper(ExecutorProfile target) {
            this.target = target;
        }

        @Override
        public Executor.ID executorId() {
            return this.target.executorId();
        }

        @Override
        public ReservationFeature reservationFeature() {
            return this.target.reservationFeature();
        }

        @Override
        public CommunicationChannelSpecification communicationChannelSpecification() {
            return this.target.communicationChannelSpecification();
        }
    }

    public static class Simple
    implements ExecutorProfile {
        private CommunicationChannelSpecification communicationChannelSpecification;
        private Executor.ID executorId;
        private ReservationFeature reservationFeature;

        public static Simple profile() {
            return new Simple();
        }

        @Override
        public Executor.ID executorId() {
            return this.executorId;
        }

        @Override
        public ReservationFeature reservationFeature() {
            return this.reservationFeature;
        }

        @Override
        public CommunicationChannelSpecification communicationChannelSpecification() {
            return this.communicationChannelSpecification;
        }

        public Simple communicationChannelSpecification(CommunicationChannelSpecification spec) {
            this.communicationChannelSpecification = spec;
            return this;
        }

        public Simple reservationFeature(ReservationFeature reservationFeature) {
            this.reservationFeature = reservationFeature;
            return this;
        }

        public Simple executorId(Executor.ID executorId) {
            this.executorId = executorId;
            return this;
        }
    }

    public static class Default
    implements ExecutorProfile {
        private final Executor.ID executorId;

        public static Default get(Executor.ID executorId) {
            return new Default(executorId);
        }

        public Default(Executor.ID executorId) {
            this.executorId = executorId;
        }

        @Override
        public Executor.ID executorId() {
            return this.executorId;
        }

        @Override
        public ReservationFeature reservationFeature() {
            return ReservationFeature.enabled;
        }

        @Override
        public CommunicationChannelSpecification communicationChannelSpecification() {
            return CommunicationChannelSpecification.ANY;
        }
    }

    public static enum CommunicationChannelSpecification {
        ANY,
        PHONE_NUMBER,
        EMAIL;

    }

    public static enum ReservationFeature {
        disabled,
        enabled;


        @Inherited
        @Documented
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.FIELD})
        @Constraint(validatedBy={Validator.class})
        public static @interface Equals {
            public String message() default "status.mismatch";

            public ReservationFeature expected();

            public Class<?>[] groups() default {};

            public Class<? extends Payload>[] payload() default {};

            public static class Validator
            implements ConstraintValidator<Equals, Object> {
                private Object expected;

                public void initialize(Equals constraintAnnotation) {
                    this.expected = constraintAnnotation.expected();
                }

                public boolean isValid(Object actual, ConstraintValidatorContext context) {
                    return this.expected.equals(actual);
                }
            }
        }
    }
}

