/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api;

import be.recipe.api.GetPrescriptionStatusResponse;
import be.recipe.api.Prescription;
import be.recipe.api.PrescriptionContent;
import be.recipe.api.PrescriptionService;
import be.recipe.api.crypto.Message;
import be.recipe.api.executor.ArchivePrescription;
import be.recipe.api.executor.GetPrescription;
import be.recipe.api.executor.GetPrescriptionAndPutInProcess;
import be.recipe.api.executor.GetPrescriptionStatus;
import be.recipe.api.executor.GetProfile;
import be.recipe.api.executor.ListPrescriptions;
import be.recipe.api.executor.UpdateProfile;
import be.recipe.api.patient.GetExecutorProfile;
import be.recipe.api.patient.ListPrescriptions;
import be.recipe.api.patient.PutVisionExecutors;
import be.recipe.api.patient.PutVisionOtherPrescribers;
import be.recipe.api.prescriber.CreatePrescription;
import be.recipe.api.prescriber.ListPrescriptions;
import be.recipe.api.prescriber.RevokePrescription;
import be.recipe.api.series.PartialResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java8.util.Optional;
import java8.util.function.Function;

public class CipheringPrescriptionService
extends PrescriptionService.Ciphering.Simplified.Abstract {
    private final PrescriptionService.Simplified target;
    private final PrescriptionContent.Factory prescriptionContentFactory;
    private Message.Cipher.Key.Owner<Prescription.OnContent> prescriber;

    public CipheringPrescriptionService(PrescriptionService.Simplified target, PrescriptionContent.Factory prescriptionContentFactory) {
        this.target = target;
        this.prescriptionContentFactory = prescriptionContentFactory;
    }

    public CipheringPrescriptionService(PrescriptionService.Simplified target, PrescriptionContent.Factory prescriptionContentFactory, Message.Cipher.Key.Owner<Prescription.OnContent> prescriber) {
        this(target, prescriptionContentFactory);
        this.prescriber = prescriber;
    }

    @Override
    public ListPrescriptions.PartialResult<ListPrescriptions.Response.PlainText> list(ListPrescriptions request) {
        ListPrescriptions.PartialResult source = this.target.list(request);
        return ListPrescriptions.PartialResult.Simple.wrap(source.map(new Function<ListPrescriptions.Response.Encrypted, ListPrescriptions.Response.PlainText>(){

            public ListPrescriptions.Response.PlainText apply(ListPrescriptions.Response.Encrypted encrypted) {
                return new DecryptingListPrescriptionsResponseForPrescriber(encrypted);
            }
        })).hasHidden(source.hasHidden());
    }

    @Override
    public PartialResult<ListPrescriptions.Response.PlainText> list(be.recipe.api.executor.ListPrescriptions request) {
        return this.target.list(request).map(new Function<ListPrescriptions.Response.Encrypted, ListPrescriptions.Response.PlainText>(){

            public ListPrescriptions.Response.PlainText apply(ListPrescriptions.Response.Encrypted encrypted) {
                return new DecryptingListPrescriptionsResponseForExecutor(encrypted);
            }
        });
    }

    @Override
    public Prescription.PlainText get(be.recipe.api.prescriber.GetPrescription request) {
        return new DecryptingPrescription((Prescription.Encrypted)this.target.get(request));
    }

    @Override
    public Prescription.PlainText add(CreatePrescription<Prescription.PlainText.Specification> request) {
        return new DecryptingPrescription((Prescription.Encrypted)this.target.add(this.request(request)));
    }

    @Override
    public Prescription.PlainText get(GetPrescription request) {
        return new DecryptingPrescription((Prescription.Encrypted)this.target.get(request));
    }

    @Override
    public Prescription.PlainText getAndPutInProcess(GetPrescriptionAndPutInProcess request) {
        return new DecryptingPrescription((Prescription.Encrypted)this.target.getAndPutInProcess(request));
    }

    @Override
    public PartialResult<ListPrescriptions.Response.PlainText> list(be.recipe.api.patient.ListPrescriptions request) {
        return this.target.list(request).map(new Function<ListPrescriptions.Response.Encrypted, ListPrescriptions.Response.PlainText>(){

            public ListPrescriptions.Response.PlainText apply(ListPrescriptions.Response.Encrypted encrypted) {
                return new DecryptingListPrescriptionsResponseForPatient(encrypted);
            }
        });
    }

    @Override
    public void update(PutVisionExecutors.Request request) {
        this.target.update(request);
    }

    private CreatePrescription<Prescription.Encrypted.Specification> request(CreatePrescription<Prescription.PlainText.Specification> request) {
        Prescription.PlainText.Specification customizations = (Prescription.PlainText.Specification)request.customizations;
        Prescription.Encrypted.Specification spec = new Prescription.Encrypted.Specification(customizations);
        if (customizations.content != null) {
            PrescriptionContent.PlainText plainText = this.prescriptionContentFactory.create(CipheringPrescriptionService.compress(customizations.content.getBytes(StandardCharsets.UTF_8)));
            PrescriptionContent.Encrypted encrypted = plainText.encrypt(customizations.patient.id(), Prescription.Type.prescriptionType("P0"));
            spec.encryptionKeyId = encrypted.key().toString();
            spec.encryptedContent = encrypted.bytes();
        }
        return new CreatePrescription<Prescription.Encrypted.Specification>(spec);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(byte[] bytes) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (GZIPOutputStream out = new GZIPOutputStream(baos);){
                out.write(bytes);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] decompress(byte[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                 GZIPInputStream in = new GZIPInputStream(bais);){
                int i;
                byte[] buffer = new byte[1024];
                while ((i = in.read(buffer)) > 0) {
                    out.write(buffer, 0, i);
                }
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void update(be.recipe.api.prescriber.PutVisionOtherPrescribers request) {
        this.target.update(request);
    }

    @Override
    public GetExecutorProfile.Response getProfile(GetExecutorProfile request) {
        return this.target.getProfile(request);
    }

    @Override
    public void updateProfile(UpdateProfile request) {
        this.target.updateProfile(request);
    }

    @Override
    public GetProfile.Response getProfile(GetProfile request) {
        return this.target.getProfile(request);
    }

    @Override
    public void update(RevokePrescription request) {
        this.target.update(request);
    }

    @Override
    public void update(be.recipe.api.patient.RevokePrescription request) {
        this.target.update(request);
    }

    @Override
    public void update(ArchivePrescription request) {
        this.target.update(request);
    }

    @Override
    public void update(PutVisionOtherPrescribers request) {
        this.target.update(request);
    }

    @Override
    public GetPrescriptionStatusResponse get(be.recipe.api.prescriber.GetPrescriptionStatus request) {
        return this.target.get(request);
    }

    @Override
    public Prescription.PlainText get(be.recipe.api.patient.GetPrescription request) {
        return new DecryptingPrescription((Prescription.Encrypted)this.target.get(request));
    }

    @Override
    public GetPrescriptionStatusResponse get(GetPrescriptionStatus getPrescriptionStatus) {
        return this.target.get(getPrescriptionStatus);
    }

    @Override
    public GetPrescriptionStatusResponse get(be.recipe.api.patient.GetPrescriptionStatus request) {
        return this.target.get(request);
    }

    private String decrypt(byte[] encryptedContent, String encryptionKey) {
        PrescriptionContent.Encrypted encrypted = this.prescriptionContentFactory.create(encryptedContent, Message.Cipher.Key.ID.keyID(encryptionKey));
        String content = (String)Optional.ofNullable((Object)this.decompress(encrypted.decrypt().bytes())).map((Function)new Function<byte[], String>(){

            public String apply(byte[] it) {
                return new String(it, StandardCharsets.UTF_8);
            }
        }).orElse((Object)"");
        return content;
    }

    public static class Factory {
        private final PrescriptionService.Simplified target;
        private final PrescriptionContent.Factory prescriptionContantFactory;

        public Factory(PrescriptionService.Simplified target, PrescriptionContent.Factory prescriptionContantFactory) {
            this.target = target;
            this.prescriptionContantFactory = prescriptionContantFactory;
        }

        public CipheringPrescriptionService create(Message.Cipher.Key.Owner<Prescription.OnContent> prescriber) {
            return new CipheringPrescriptionService(this.target, this.prescriptionContantFactory, prescriber);
        }
    }

    private class DecryptingListPrescriptionsResponseForPatient
    extends ListPrescriptions.Response.Encrypted.Wrapper
    implements ListPrescriptions.Response.PlainText {
        public DecryptingListPrescriptionsResponseForPatient(ListPrescriptions.Response.Encrypted target) {
            super(target);
        }

        @Override
        public String prescriptionContent() {
            return CipheringPrescriptionService.this.decrypt(this.encryptedPrescriptionContent(), this.encryptionKey());
        }
    }

    private class DecryptingListPrescriptionsResponseForExecutor
    extends ListPrescriptions.Response.Encrypted.Wrapper
    implements ListPrescriptions.Response.PlainText {
        public DecryptingListPrescriptionsResponseForExecutor(ListPrescriptions.Response.Encrypted target) {
            super(target);
        }

        @Override
        public String prescriptionContent() {
            return CipheringPrescriptionService.this.decrypt(this.encryptedPrescriptionContent(), this.encryptionKey());
        }
    }

    private class DecryptingListPrescriptionsResponseForPrescriber
    extends ListPrescriptions.Response.Encrypted.Wrapper
    implements ListPrescriptions.Response.PlainText {
        public DecryptingListPrescriptionsResponseForPrescriber(ListPrescriptions.Response.Encrypted target) {
            super(target);
        }

        @Override
        public String prescriptionContent() {
            return CipheringPrescriptionService.this.decrypt(this.encryptedPrescriptionContent(), this.encryptionKey());
        }
    }

    private class DecryptingPrescription
    extends Prescription.Encrypted.Wrapper
    implements Prescription.PlainText {
        private final Prescription.Encrypted target;

        public DecryptingPrescription(Prescription.Encrypted target) {
            super(target);
            this.target = target;
        }

        @Override
        public String content() {
            return (String)Optional.ofNullable((Object)this.target.encryptionKey()).flatMap((Function)new Function<String, Optional<String>>(){

                public Optional<String> apply(final String encryptionKey) {
                    return Optional.ofNullable((Object)DecryptingPrescription.this.target.encryptedContent()).map((Function)new Function<byte[], String>(){

                        public String apply(byte[] encryptedContent) {
                            return CipheringPrescriptionService.this.decrypt(encryptedContent, encryptionKey);
                        }
                    });
                }
            }).orElse(null);
        }
    }
}

