/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.series;

import be.recipe.api.series.Window;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WindowTest {
    @Test
    public void defaultSizeWindow() {
        Window window = Window.offset((int)0);
        Assertions.assertEquals((int)0, (int)window.offset);
        Assertions.assertEquals((int)50, (int)window.count);
    }

    @Test
    public void customWindowSize() {
        Window window = Window.offset((int)0).count(20);
        Assertions.assertEquals((int)0, (int)window.offset);
        Assertions.assertEquals((int)20, (int)window.count);
    }

    @Test
    public void previous_fromOffsetZero() {
        Window window = Window.offset((int)0).previous();
        Assertions.assertEquals((int)0, (int)window.offset);
        Assertions.assertEquals((int)50, (int)window.count);
    }

    @Test
    public void previous() {
        Window window = Window.offset((int)100).previous();
        Assertions.assertEquals((int)50, (int)window.offset);
        Assertions.assertEquals((int)50, (int)window.count);
    }

    @Test
    public void previous_withCustomCount() {
        Window window = Window.offset((int)100).count(20).previous();
        Assertions.assertEquals((int)80, (int)window.offset);
        Assertions.assertEquals((int)20, (int)window.count);
    }

    @Test
    public void next() {
        Window window = Window.offset((int)0).next();
        Assertions.assertEquals((int)50, (int)window.offset);
        Assertions.assertEquals((int)50, (int)window.count);
    }

    @Test
    public void next_withCustomCount() {
        Window window = Window.offset((int)0).count(20).next();
        Assertions.assertEquals((int)20, (int)window.offset);
        Assertions.assertEquals((int)20, (int)window.count);
    }
}

