/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.series;

import be.recipe.api.series.PartialResult;
import java.util.Collections;
import java8.util.stream.StreamSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PartialResultTest {
    PartialResult target = (PartialResult)Mockito.mock(PartialResult.class);

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.target.stream()).thenReturn((Object)StreamSupport.stream(Collections.emptyList()));
    }

    @Test
    public void empty() {
        Assertions.assertFalse((boolean)PartialResult.Simple.empty().hasMore());
        Assertions.assertEquals((long)0L, (long)PartialResult.Simple.empty().stream().count());
    }

    @Test
    public void streamFromBuffered_delegatesToTarget() {
        PartialResult.Simple.buffered((PartialResult)this.target).stream();
        ((PartialResult)Mockito.verify((Object)this.target)).stream();
    }

    @Test
    public void streamingMultipleTimesFromBuffered_delegatesOnce() {
        PartialResult buffered = PartialResult.Simple.buffered((PartialResult)this.target);
        buffered.stream();
        buffered.stream();
        ((PartialResult)Mockito.verify((Object)this.target, (VerificationMode)Mockito.times((int)1))).stream();
    }

    @Test
    public void hasMoreFromBuffered_delegatesToTarget() {
        PartialResult.Simple.buffered((PartialResult)this.target).hasMore();
        ((PartialResult)Mockito.verify((Object)this.target)).hasMore();
    }
}

