/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.prescription;

import be.recipe.api.Prescription;
import be.recipe.api.PrescriptionContent;
import be.recipe.api.crypto.AESCipher;
import be.recipe.api.crypto.InmemKeyDB;
import be.recipe.api.crypto.Message;
import be.recipe.api.executor.Executor;
import be.recipe.api.patient.Patient;
import be.recipe.api.prescriber.Prescriber;
import be.recipe.api.prescriber.PrescriberType;
import be.recipe.api.timestamping.SimpleTimestampingContext;
import java.nio.charset.StandardCharsets;
import java8.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PrescriptionContentTimestampingTest {
    private final AESCipher cipher = new AESCipher();
    private final InmemKeyDB db = new InmemKeyDB(this.cipher.toSpec());
    private final SimpleTimestampingContext ctx = new SimpleTimestampingContext();
    private PrescriptionContent.Factory factory;

    @BeforeEach
    public void setup() {
        this.factory = new PrescriptionContent.Factory(new Message.Factory((Message.Cipher)this.cipher, (Message.Encrypted.Timestamped.Extractor)this.ctx), (Message.Cipher.Key.DB)this.db);
    }

    @Test
    public void decipherTimestampedPrescription() {
        final PrescriptionContent.PlainText plainText = this.factory.create("Hello World!".getBytes(StandardCharsets.UTF_8));
        Prescriber.Simple prescriber = Prescriber.Simple.prescriber((PrescriberType)PrescriberType.DOCTOR, (Prescriber.ID)Prescriber.ID.prescriberID((String)"-"));
        PrescriptionContent.Encrypted encrypted = this.as((Message.Cipher.Key.Owner<Prescription.OnContent>)prescriber, new Supplier<PrescriptionContent.Encrypted>(){

            public PrescriptionContent.Encrypted get() {
                return plainText.encrypt(Patient.ID.patientID((String)"-"), Prescription.Type.prescriptionType((String)"P0"));
            }
        });
        final PrescriptionContent.Encrypted.Timestamped timestamped = this.factory.timestamped(this.ctx.compact(encrypted.bytes()), encrypted.key());
        this.as(Executor.ID.executorId((String)"-"), new Runnable(){

            @Override
            public void run() {
                Assertions.assertEquals((Object)"Hello World!", (Object)PrescriptionContentTimestampingTest.this.string(timestamped.decrypt().bytes()));
            }
        });
    }

    @Test
    public void decipherTimestampedPrescription_legacyBytes() {
        final PrescriptionContent.PlainText plainText = this.factory.create("Hello World!".getBytes(StandardCharsets.UTF_8));
        Prescriber.Simple prescriber = Prescriber.Simple.prescriber((PrescriberType)PrescriberType.DOCTOR, (Prescriber.ID)Prescriber.ID.prescriberID((String)"-"));
        PrescriptionContent.Encrypted encrypted = this.as((Message.Cipher.Key.Owner<Prescription.OnContent>)prescriber, new Supplier<PrescriptionContent.Encrypted>(){

            public PrescriptionContent.Encrypted get() {
                return plainText.encrypt(Patient.ID.patientID((String)"-"), Prescription.Type.prescriptionType((String)"P0"));
            }
        });
        final PrescriptionContent.Encrypted.Timestamped timestamped = this.factory.timestamped(encrypted.bytes(), encrypted.key());
        this.as(Executor.ID.executorId((String)"-"), new Runnable(){

            @Override
            public void run() {
                Assertions.assertEquals((Object)"Hello World!", (Object)PrescriptionContentTimestampingTest.this.string(timestamped.decrypt().bytes()));
            }
        });
    }

    private <T> T as(Message.Cipher.Key.Owner<Prescription.OnContent> owner, Supplier<T> task) {
        this.db.owner = owner;
        return (T)task.get();
    }

    private void as(Executor.ID executor, final Runnable task) {
        this.as((Message.Cipher.Key.Owner<Prescription.OnContent>)executor, new Supplier<Object>(){

            public Object get() {
                task.run();
                return null;
            }
        });
    }

    private String string(byte[] enciphered) {
        return new String(enciphered, StandardCharsets.UTF_8);
    }
}

