/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.prescription;

import be.recipe.api.CipheringPrescriptionService;
import be.recipe.api.Prescription;
import be.recipe.api.PrescriptionContent;
import be.recipe.api.PrescriptionService;
import be.recipe.api.Registered;
import be.recipe.api.crypto.AESCipher;
import be.recipe.api.crypto.InmemKeyDB;
import be.recipe.api.crypto.Message;
import be.recipe.api.executor.GetPrescription;
import be.recipe.api.executor.ListPrescriptions;
import be.recipe.api.patient.Patient;
import be.recipe.api.prescriber.CreatePrescription;
import be.recipe.api.prescriber.ListPrescriptions;
import be.recipe.api.prescriber.Prescriber;
import be.recipe.api.prescriber.PrescriberType;
import be.recipe.api.series.PartialResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java8.util.function.Supplier;
import java8.util.stream.Collectors;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class CipheringPrescriptionServiceTest {
    private AESCipher cipher = new AESCipher();
    private InmemKeyDB keyRegistry = new InmemKeyDB(this.cipher.toSpec());
    private PrescriptionContent.Factory factory = new PrescriptionContent.Factory(new Message.Factory((Message.Cipher)this.cipher, null), (Message.Cipher.Key.DB)this.keyRegistry);
    private PrescriptionService.Simplified target = (PrescriptionService.Simplified)Mockito.mock(PrescriptionService.Simplified.class);
    private CipheringPrescriptionService service = new CipheringPrescriptionService(this.target, this.factory);

    @BeforeEach
    public void setup() {
        this.keyRegistry.owner = Prescriber.Simple.prescriber((PrescriberType)PrescriberType.DOCTOR, (Prescriber.ID)Prescriber.ID.prescriberID((String)"-"));
        this.mockDefaultBehaviors();
    }

    private void mockDefaultBehaviors() {
        Mockito.when((Object)this.target.list((be.recipe.api.executor.ListPrescriptions)Mockito.any(be.recipe.api.executor.ListPrescriptions.class))).thenReturn((Object)PartialResult.Simple.of((Supplier)new Supplier<Stream<ListPrescriptions.Response.Encrypted>>(){

            public Stream<ListPrescriptions.Response.Encrypted> get() {
                return StreamSupport.stream(Collections.emptyList());
            }
        }));
        Mockito.when((Object)this.target.list((ListPrescriptions)Mockito.any(ListPrescriptions.class))).thenReturn((Object)ListPrescriptions.PartialResult.Simple.wrap((PartialResult)PartialResult.Simple.of((Supplier)new Supplier<Stream<ListPrescriptions.Response.Encrypted>>(){

            public Stream<ListPrescriptions.Response.Encrypted> get() {
                return StreamSupport.stream(Collections.emptyList());
            }
        })));
    }

    @Test
    public void add_acceptsNullTreatment() {
        this.service.add(this.addRequest(null));
        ArgumentCaptor args = ArgumentCaptor.forClass(CreatePrescription.class);
        ((PrescriptionService.Simplified)Mockito.verify((Object)this.target)).add((CreatePrescription)args.capture());
        Assertions.assertNull((Object)((Prescription.Encrypted.Specification)((CreatePrescription)args.getValue()).customizations).encryptedContent);
        Assertions.assertNull((Object)((Prescription.Encrypted.Specification)((CreatePrescription)args.getValue()).customizations).encryptionKeyId);
    }

    @Test
    public void add_enciphersTreatment() {
        this.service.add(this.addRequest("t"));
        ArgumentCaptor args = ArgumentCaptor.forClass(CreatePrescription.class);
        ((PrescriptionService.Simplified)Mockito.verify((Object)this.target)).add((CreatePrescription)args.capture());
        Assertions.assertEquals((Object)"t", (Object)this.treatment((Prescription.Encrypted.Specification)((CreatePrescription)args.getValue()).customizations));
    }

    @Test
    public void add_deciphersResponseFromTarget() {
        PrescriptionContent.Encrypted encrypted = this.treatment("t");
        Prescription.Encrypted.Simple prescription = new Prescription.Encrypted.Simple();
        prescription.setEncryptedContent(encrypted.bytes());
        prescription.setEncryptionKey(encrypted.key().toString());
        Mockito.when((Object)this.target.add((CreatePrescription)Mockito.any(CreatePrescription.class))).thenReturn((Object)prescription);
        Assertions.assertEquals((Object)"t", (Object)this.service.add(this.addRequest()).content());
    }

    @Test
    public void listAsPrescriber_delegatesToTarget() {
        ListPrescriptions request = (ListPrescriptions)Mockito.mock(ListPrescriptions.class);
        this.service.list(request);
        ((PrescriptionService.Simplified)Mockito.verify((Object)this.target)).list(request);
    }

    @Test
    public void listAsPrescriber_returnsResponseFromTarget() {
        ListPrescriptions.PartialResult.Simple expected = ListPrescriptions.PartialResult.Simple.wrap((PartialResult)PartialResult.Simple.of((Object[])new ListPrescriptions.Response.Encrypted[]{ListPrescriptions.Response.Encrypted.Simple.response((Prescription.RID)Prescription.RID.prescriptionID((String)"p")).prescriptionContent(this.treatment("t"))}));
        Mockito.when((Object)this.target.list((ListPrescriptions)Mockito.any(ListPrescriptions.class))).thenReturn((Object)expected);
        ListPrescriptions.PartialResult actual = this.service.list((ListPrescriptions)Mockito.mock(ListPrescriptions.class));
        Assertions.assertEquals((Object)expected.stream().map(Registered.Simple.toRID()).collect(Collectors.toList()), (Object)actual.stream().map(Registered.Simple.toRID()).collect(Collectors.toList()));
        Assertions.assertEquals(Arrays.asList("t"), (Object)actual.stream().map(ListPrescriptions.Response.PlainText.Simple.toPrescriptionContent()).collect(Collectors.toList()));
    }

    @Test
    public void listAsPrescriber_returnsResponseFromTarget_withoutContent() {
        ListPrescriptions.PartialResult.Simple expected = ListPrescriptions.PartialResult.Simple.wrap((PartialResult)PartialResult.Simple.of((Object[])new ListPrescriptions.Response.Encrypted[]{ListPrescriptions.Response.Encrypted.Simple.response((Prescription.RID)Prescription.RID.prescriptionID((String)"p")).prescriptionContent(this.emptyTreatment())}));
        Mockito.when((Object)this.target.list((ListPrescriptions)Mockito.any(ListPrescriptions.class))).thenReturn((Object)expected);
        ListPrescriptions.PartialResult actual = this.service.list((ListPrescriptions)Mockito.mock(ListPrescriptions.class));
        Assertions.assertEquals((Object)expected.stream().map(Registered.Simple.toRID()).collect(Collectors.toList()), (Object)actual.stream().map(Registered.Simple.toRID()).collect(Collectors.toList()));
        Assertions.assertEquals(Arrays.asList(""), (Object)actual.stream().map(ListPrescriptions.Response.PlainText.Simple.toPrescriptionContent()).collect(Collectors.toList()));
    }

    @Test
    public void listAsExecutor_delegatesToTarget() {
        be.recipe.api.executor.ListPrescriptions request = (be.recipe.api.executor.ListPrescriptions)Mockito.mock(be.recipe.api.executor.ListPrescriptions.class);
        this.service.list(request);
        ((PrescriptionService.Simplified)Mockito.verify((Object)this.target)).list(request);
    }

    @Test
    public void listAsExecutor_returnsResponseFromTarget() {
        PartialResult.Simple expected = PartialResult.Simple.of((Object[])new ListPrescriptions.Response.Encrypted[]{ListPrescriptions.Response.Encrypted.Simple.response((Prescription.RID)Prescription.RID.prescriptionID((String)"p")).prescriptionContent(this.treatment("t"))});
        Mockito.when((Object)this.target.list((be.recipe.api.executor.ListPrescriptions)Mockito.any(be.recipe.api.executor.ListPrescriptions.class))).thenReturn((Object)expected);
        PartialResult actual = this.service.list((be.recipe.api.executor.ListPrescriptions)Mockito.mock(be.recipe.api.executor.ListPrescriptions.class));
        Assertions.assertEquals((Object)expected.stream().map(Registered.Simple.toRID()).collect(Collectors.toList()), (Object)actual.stream().map(Registered.Simple.toRID()).collect(Collectors.toList()));
        Assertions.assertEquals(Arrays.asList("t"), (Object)actual.stream().map(ListPrescriptions.Response.PlainText.Simple.toContent()).collect(Collectors.toList()));
    }

    @Test
    public void get_delegatesToTarget() {
        be.recipe.api.prescriber.GetPrescription request = (be.recipe.api.prescriber.GetPrescription)Mockito.mock(be.recipe.api.prescriber.GetPrescription.class);
        this.service.get(request);
        ((PrescriptionService.Simplified)Mockito.verify((Object)this.target)).get(request);
    }

    @Test
    public void getAsPrescriber_returnsPlainPrescription() {
        PrescriptionContent.Encrypted encrypted = this.treatment("t");
        Prescription.Encrypted.Simple source = new Prescription.Encrypted.Simple();
        source.setEncryptedContent(encrypted.bytes());
        source.setEncryptionKey(encrypted.key().toString());
        Mockito.when((Object)this.target.get((be.recipe.api.prescriber.GetPrescription)Mockito.any(be.recipe.api.prescriber.GetPrescription.class))).thenReturn((Object)source);
        Prescription.PlainText prescription = this.service.get((be.recipe.api.prescriber.GetPrescription)Mockito.mock(be.recipe.api.prescriber.GetPrescription.class));
        Assertions.assertEquals((Object)"t", (Object)prescription.content());
    }

    @Test
    public void getAsPrescriber_returnsPrescription_withoutEncryptionKey() {
        Prescription.Encrypted.Simple source = new Prescription.Encrypted.Simple();
        source.setEncryptedContent(this.treatment("t").bytes());
        Mockito.when((Object)this.target.get((be.recipe.api.prescriber.GetPrescription)Mockito.any(be.recipe.api.prescriber.GetPrescription.class))).thenReturn((Object)source);
        Prescription.PlainText prescription = this.service.get((be.recipe.api.prescriber.GetPrescription)Mockito.mock(be.recipe.api.prescriber.GetPrescription.class));
        Assertions.assertNull((Object)prescription.content());
    }

    @Test
    public void getAsPrescriber_returnsPrescription_withoutEncryptedContent() {
        Prescription.Encrypted.Simple source = new Prescription.Encrypted.Simple();
        source.setEncryptionKey("-");
        Mockito.when((Object)this.target.get((be.recipe.api.prescriber.GetPrescription)Mockito.any(be.recipe.api.prescriber.GetPrescription.class))).thenReturn((Object)source);
        Prescription.PlainText prescription = this.service.get((be.recipe.api.prescriber.GetPrescription)Mockito.mock(be.recipe.api.prescriber.GetPrescription.class));
        Assertions.assertNull((Object)prescription.content());
    }

    @Test
    public void getAsExecutor_returnsPlainPrescription() {
        PrescriptionContent.Encrypted encrypted = this.treatment("t");
        Prescription.Encrypted.Simple source = new Prescription.Encrypted.Simple();
        source.setEncryptedContent(encrypted.bytes());
        source.setEncryptionKey(encrypted.key().toString());
        Mockito.when((Object)this.target.get((GetPrescription)Mockito.any(GetPrescription.class))).thenReturn((Object)source);
        Prescription.PlainText prescription = this.service.get((GetPrescription)Mockito.mock(GetPrescription.class));
        Assertions.assertEquals((Object)"t", (Object)prescription.content());
    }

    private PrescriptionContent.Encrypted treatment(String it) {
        return this.factory.create(this.compress(it.getBytes(StandardCharsets.UTF_8))).encrypt(Patient.ID.patientID((String)"-"), Prescription.Type.prescriptionType((String)"-"));
    }

    private PrescriptionContent.Encrypted emptyTreatment() {
        PrescriptionContent.Encrypted treatment = this.treatment("-");
        return this.factory.create(null, treatment.key());
    }

    private CreatePrescription addRequest(String treatment) {
        Prescription.PlainText.Specification spec = new Prescription.PlainText.Specification();
        spec.content = treatment;
        spec.patient = new Patient.Simple(Patient.ID.patientID((String)"-"));
        return new CreatePrescription((Prescription.Specification)spec);
    }

    private CreatePrescription addRequest() {
        return this.addRequest("-");
    }

    private String treatment(Prescription.Encrypted.Specification spec) {
        return new String(this.decompress(this.factory.create(spec.encryptedContent, Message.Cipher.Key.ID.keyID((String)spec.encryptionKeyId)).decrypt().bytes()), StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] compress(byte[] bytes) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (GZIPOutputStream out = new GZIPOutputStream(baos);){
                out.write(bytes);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] decompress(byte[] bytes) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try (GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bytes));){
                int i;
                byte[] buffer = new byte[1024];
                while ((i = in.read(buffer)) > 0) {
                    out.write(buffer, 0, i);
                }
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

