/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.constraints;

import be.recipe.api.constraints.Rejected;
import be.recipe.api.constraints.ValidationReport;
import be.recipe.api.constraints.Violation;
import java.util.Arrays;
import java8.util.function.Supplier;
import java8.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;

public class ValidationReportTest {
    private final ValidationReport.Simple report = new ValidationReport.Simple();

    @Test
    public void stream() {
        this.report.violations(new Violation.Simple.Builder[]{Violation.Simple.violation((String)"x"), Violation.Simple.violation((String)"y"), Violation.Simple.violation((String)"z")});
        Assertions.assertEquals(Arrays.asList("x", "y", "z"), (Object)this.report.stream().map(Violation.Simple.toViolation()).collect(Collectors.toList()));
    }

    @Test
    public void ifRejectedThrow_returnsReport_ifNotRejected() {
        Assertions.assertEquals((Object)this.report, (Object)this.report.ifRejectedThrow());
    }

    @Test
    public void ifRejectedThrow() {
        this.report.violations(new Violation.Simple.Builder[]{Violation.Simple.violation((String)"-")});
        Assertions.assertThrows(Rejected.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                ValidationReportTest.this.report.ifRejectedThrow();
            }
        });
    }

    @Test
    public void ifRejectedThrow_exposesReport() {
        try {
            this.report.violations(new Violation.Simple.Builder[]{Violation.Simple.violation((String)"-")});
            this.report.ifRejectedThrow();
            Assertions.fail();
        }
        catch (Rejected e) {
            Assertions.assertEquals((Object)this.report, (Object)e.report());
        }
    }

    @Test
    public void executeTask_ifNotRejected() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        this.report.ifRejectedThrow().orElse(task);
        ((Runnable)Mockito.verify((Object)task)).run();
    }

    @Test
    public void executeSupplier_ifNotRejected() {
        Supplier task = (Supplier)Mockito.mock(Supplier.class);
        this.report.ifRejectedThrow().orElse(task);
        ((Supplier)Mockito.verify((Object)task)).get();
    }

    @Test
    public void returnValueFromSupplier_ifNotRejected() {
        Assertions.assertEquals((Object)"x", (Object)this.report.ifRejectedThrow().orElse((Supplier)new Supplier<String>(){

            public String get() {
                return "x";
            }
        }));
    }
}

