package be.recipe.api.text;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotEquals;

public class ExtendableStringTest {
  @Test
  public void toString_delegatesTo_internalString() {
    assertEquals("x", new TestMessage("x").toString());
  }

  @Test
  public void equals_delegatesTo_internalString() {
    assertNotEquals(new TestMessage("x"), "x");
    assertNotEquals(new TestMessage("x"), new TestMessage("y"));
    assertEquals(new TestMessage("x"), new TestMessage("x"));
    assertEquals(new TestMessage("x"), new TestMessage("x"));
  }

  private static class TestMessage extends ExtendableString {
    public TestMessage(String value) {
      super(value);
    }
  }
}
