package be.recipe.api.series;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class WindowTest {
    @Test
    public void defaultSizeWindow() {
        // tag::default-size-window[]
        Window window = Window.offset(0);
        assertEquals(0, window.offset);
        assertEquals(50, window.count);
        // end::default-size-window[]
    }

    @Test
    public void customWindowSize() {
        // tag::custom-window-size[]
        Window window = Window.offset(0).count(20);
        assertEquals(0, window.offset);
        assertEquals(20, window.count);
        // end::custom-window-size[]
    }

    @Test
    public void previous_fromOffsetZero() {
        Window window = Window.offset(0).previous();
        assertEquals(0, window.offset);
        assertEquals(50, window.count);
    }

    @Test
    public void previous() {
        // tag::previous-window[]
        Window window = Window.offset(100).previous();
        assertEquals(50, window.offset);
        assertEquals(50, window.count);
        // end::previous-window[]
    }

    @Test
    public void previous_withCustomCount() {
        Window window = Window.offset(100).count(20).previous();
        assertEquals(80, window.offset);
        assertEquals(20, window.count);
    }

    @Test
    public void next() {
        // tag::next-window[]
        Window window = Window.offset(0).next();
        assertEquals(50, window.offset);
        assertEquals(50, window.count);
        // end::next-window[]
    }

    @Test
    public void next_withCustomCount() {
        Window window = Window.offset(0).count(20).next();
        assertEquals(20, window.offset);
        assertEquals(20, window.count);
    }
}