package be.recipe.api.series;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static be.recipe.api.series.PartialResult.Simple.buffered;
import static java.util.Collections.emptyList;
import static java8.util.stream.StreamSupport.stream;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.mockito.Mockito.*;

@SuppressWarnings("ALL")
public class PartialResultTest {
  PartialResult target = mock(PartialResult.class);

  @BeforeEach
  public void setup() {
    when(target.stream()).thenReturn(stream(emptyList()));
  }

  @Test
  public void empty() {
    assertFalse(PartialResult.Simple.empty().hasMore());
    assertEquals(0, PartialResult.Simple.empty().stream().count());
  }

  @Test
  public void streamFromBuffered_delegatesToTarget() {
    buffered(target).stream();
    verify(target).stream();
  }

  @Test
  public void streamingMultipleTimesFromBuffered_delegatesOnce() {
    PartialResult buffered = buffered(target);
    buffered.stream();
    buffered.stream();
    verify(target, times(1)).stream();
  }

  @Test
  public void hasMoreFromBuffered_delegatesToTarget() {
    buffered(target).hasMore();
    verify(target).hasMore();
  }
}
