package be.recipe.api.series;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class PageTest {
  @Test
  public void firstPage() {
    // tag::first-page[]
    assertEquals(1, Page.first().number);
    // end::first-page[]
  }

  @Test
  public void customPage() {
    // tag::custom-page[]
    assertEquals(5, Page.page(5).number);
    // end::custom-page[]
  }

  @Test
  public void previous_fromFirstPage() {
    assertEquals(1, Page.first().previous().number);
  }

  @Test
  public void previous() {
    // tag::previous-page[]
    assertEquals(4, Page.page(5).previous().number);
    // end::previous-page[]
  }

  @Test
  public void next() {
    // tag::next-page[]
    assertEquals(2, Page.first().next().number);
    // end::next-page[]
  }

  @Test
  public void next_fromCustomPage() {
    assertEquals(6, Page.page(5).next().number);
  }

  @Test
  public void firstPage_asWindow() {
    // tag::first-page-as-window[]
    Window window = Page.first().window();
    assertEquals(0, window.offset);
    assertEquals(50, window.count);
    // end::first-page-as-window[]
  }

  @Test
  public void customPage_asWindow() {
    // tag::custom-page-as-window[]
    Window window = Page.page(3).window();
    assertEquals(100, window.offset);
    assertEquals(50, window.count);
    // end::custom-page-as-window[]
  }
}
