package be.recipe.api.reservation;

import static be.recipe.api.reservation.Reservation.Status.*;
import static org.junit.jupiter.api.Assertions.assertEquals;

import org.junit.jupiter.api.Test;

public class ReservationTest {
  @Test
  public void convertStatusToComparable() {
    assertEquals(1, Reservation.Status.comparator().compare(REQUESTED, CANCELLED));
    assertEquals(
        1, Reservation.Status.comparator().compare(REQUESTED, REQUESTED_WITHOUT_COMMITMENT));
    assertEquals(1, Reservation.Status.comparator().compare(ACCEPTED, CANCELLED));
    assertEquals(1, Reservation.Status.comparator().compare(CANCELLATION_REQUESTED, CANCELLED));
    assertEquals(1, Reservation.Status.comparator().compare(REJECTED, CANCELLED));
    assertEquals(1, Reservation.Status.comparator().compare(REQUESTED, REJECTED));
    assertEquals(1, Reservation.Status.comparator().compare(ACCEPTED, REJECTED));
    assertEquals(1, Reservation.Status.comparator().compare(CANCELLATION_REQUESTED, REJECTED));
  }
}
