package be.recipe.api.timestamping;

import be.recipe.api.crypto.Message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import static java.nio.charset.StandardCharsets.UTF_8;

public class SimpleTimestampingContext implements Message.Encrypted.Timestamped.Context {
  public byte[] compact(byte[] bytes) {
    try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
      out.write('M');
      out.write(bytes);
      return out.toByteArray();
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  @Override
  public byte[] encrypted(byte[] bytes) {
    if (!new String(new byte[] {bytes[0]}, UTF_8).equals("M"))
      throw new Message.Encrypted.Timestamped.ExtractionFailed();
    try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
      out.write(bytes, 1, bytes.length - 1);
      return out.toByteArray();
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }
}
