package be.recipe.api.time;

import org.threeten.bp.LocalDate;

import java.util.Objects;

public class LocalDateRange {
  private final LocalDate start, end;

  public static LocalDateRange of(LocalDate start, LocalDate end) {
    return new LocalDateRange(start, end);
  }

  public static LocalDateRange ofClosed(LocalDate start, LocalDate end) {
    return of(start, end.plusDays(1));
  }

  private LocalDateRange(LocalDate start, LocalDate end) {
    this.start = start;
    this.end = end;
  }

  public LocalDate getStart() {
    return start;
  }

  public LocalDate getEnd() {
    return end;
  }

  public LocalDate getEndInclusive() {
    return end.minusDays(1);
  }

  public boolean contains(LocalDate dt) {
    return !dt.isBefore(start) && dt.isBefore(end);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof LocalDateRange)) return false;
    LocalDateRange that = (LocalDateRange) o;
    return start.equals(that.start) && end.equals(that.end);
  }

  @Override
  public int hashCode() {
    return Objects.hash(start, end);
  }

  @Override
  public String toString() {
    return "LocalDateRange{" + "start=" + start + ", end=" + end + '}';
  }
}
