package be.recipe.api.text;

import static java.util.Arrays.asList;
import static java8.util.stream.StreamSupport.stream;

import java.util.List;
import java.util.Locale;
import java8.util.stream.Stream;

public class LocalisedMessage {
  private final Locale locale;
  private final String value;

  private LocalisedMessage(Locale locale, String value) {
    this.locale = locale;
    this.value = value;
  }

  public static Context context(String id, Locale... locales) {
    return new Context(id, asList(locales));
  }

  public static LocalisedMessage message(Locale locale, String value) {
    return new LocalisedMessage(locale, value);
  }

  public Locale locale() {
    return locale;
  }

  public String value() {
    return value;
  }

  @Override
  public String toString() {
    return "[" + locale + "] " + value;
  }

  public static class Context {
    private final List<Locale> locales;
    private final String id;

    public Context(String id, List<Locale> locales) {
      this.id = id;
      this.locales = locales;
    }

    public String id() {
      return id;
    }

    public Stream<Locale> locales() {
      return stream(locales);
    }
  }
}
