package be.recipe.api.reservation.executor;

import be.recipe.api.executor.*;

public interface ReservationService<
        L extends ListReservations.Request,
        A extends AcceptReservation,
        R extends RejectReservation,
        C extends AcceptReservationCancellationRequest,
        F extends FulfillReservation>
    extends ListReservations<L>,
        AcceptReservation.Command<A>,
        RejectReservation.Command<R>,
        AcceptReservationCancellationRequest.Command<C>,
        FulfillReservation.Command<F> {
  interface Simplified
      extends ReservationService<
          ListReservations.Request,
          AcceptReservation,
          RejectReservation,
      AcceptReservationCancellationRequest,
          FulfillReservation> {}
}
