package be.recipe.api.prescriber;

import be.recipe.api.constraints.Known;
import be.recipe.api.Prescription;

import javax.validation.constraints.NotNull;

import static be.recipe.api.Prescription.illegal_access;

// tag::feature[]
@Known(message = illegal_access)
public class PutVisionOtherPrescribers {
  @NotNull public Prescription.RID prescription;
  @NotNull public VisionOtherPrescribers vision;
  // end::feature[]

  public PutVisionOtherPrescribers() {}

  public PutVisionOtherPrescribers(Prescription.RID prescription) {
    this.prescription = prescription;
  }

  public PutVisionOtherPrescribers(Prescription.RID prescription, VisionOtherPrescribers vision) {
    this(prescription);
    this.vision = vision;
  }
  // tag::feature[]

  public interface Command<Request extends PutVisionOtherPrescribers> {
    void update(Request request);
  }
}
// end::feature[]
