// tag::class-ciphering[]
package be.recipe.api.prescriber;

// end::class-ciphering[]

// tag::class-ciphering[]
public interface PrescriptionService
// end::class-ciphering[]
<
        Prescription extends be.recipe.api.Prescription,
        GetPrescriptionStatusResponse extends be.recipe.api.GetPrescriptionStatusResponse,
        ListPrescriptions extends be.recipe.api.prescriber.ListPrescriptions,
        ListPrescriptionsResponse extends be.recipe.api.prescriber.ListPrescriptions.Response,
        GetPrescription extends be.recipe.api.prescriber.GetPrescription,
        GetPrescriptionStatus extends be.recipe.api.prescriber.GetPrescriptionStatus,
        PrescriptionSpecifications extends be.recipe.api.Prescription.Specification,
        CreatePrescription extends
            be.recipe.api.prescriber.CreatePrescription<PrescriptionSpecifications>,
        PutVisionOtherPrescribers extends be.recipe.api.prescriber.PutVisionOtherPrescribers,
        RevokePrescription extends be.recipe.api.prescriber.RevokePrescription>
    extends be.recipe.api.prescriber.ListPrescriptions.Command<
            ListPrescriptions, ListPrescriptionsResponse>,
        be.recipe.api.prescriber.GetPrescription.Command<GetPrescription, Prescription>,
        be.recipe.api.prescriber.GetPrescriptionStatus.Command<
            GetPrescriptionStatus, GetPrescriptionStatusResponse>,
        be.recipe.api.prescriber.CreatePrescription.Command<
            PrescriptionSpecifications, CreatePrescription, Prescription>,
        be.recipe.api.prescriber.PutVisionOtherPrescribers.Command<PutVisionOtherPrescribers>,
        be.recipe.api.prescriber.RevokePrescription.Command<RevokePrescription> {
  interface Simplified
      extends PrescriptionService<
              be.recipe.api.Prescription.Encrypted,
              be.recipe.api.GetPrescriptionStatusResponse,
              be.recipe.api.prescriber.ListPrescriptions,
              be.recipe.api.prescriber.ListPrescriptions.Response.Encrypted,
              be.recipe.api.prescriber.GetPrescription,
              be.recipe.api.prescriber.GetPrescriptionStatus,
              be.recipe.api.Prescription.Encrypted.Specification,
              be.recipe.api.prescriber.CreatePrescription<
                  be.recipe.api.Prescription.Encrypted.Specification>,
              be.recipe.api.prescriber.PutVisionOtherPrescribers,
              be.recipe.api.prescriber.RevokePrescription>,
          be.recipe.api.prescriber.GetPrescription.Command<
              be.recipe.api.prescriber.GetPrescription, be.recipe.api.Prescription.Encrypted> {}

  // tag::class-ciphering[]
  interface Ciphering
  // end::class-ciphering[]
  <
          ListPrescriptions extends be.recipe.api.prescriber.ListPrescriptions,
          GetPrescription extends be.recipe.api.prescriber.GetPrescription,
          CreatePrescription extends
              be.recipe.api.prescriber.CreatePrescription<
                      be.recipe.api.Prescription.PlainText.Specification>>
      // tag::class-ciphering[]
      extends PrescriptionService
              // end::class-ciphering[]
              <
              be.recipe.api.Prescription.PlainText,
              be.recipe.api.GetPrescriptionStatusResponse,
              ListPrescriptions,
              be.recipe.api.prescriber.ListPrescriptions.Response.PlainText,
              GetPrescription,
              be.recipe.api.prescriber.GetPrescriptionStatus,
              be.recipe.api.Prescription.PlainText.Specification,
              CreatePrescription,
              be.recipe.api.prescriber.PutVisionOtherPrescribers,
              be.recipe.api.prescriber.RevokePrescription>,
          be.recipe.api.prescriber.GetPrescription.Command<
              GetPrescription, be.recipe.api.Prescription.PlainText>
  // tag::class-ciphering[]
  {
    interface Simplified
        extends Ciphering<
            be.recipe.api.prescriber.ListPrescriptions,
            be.recipe.api.prescriber.GetPrescription,
            be.recipe.api.prescriber.CreatePrescription<
                be.recipe.api.Prescription.PlainText.Specification>> {}
  }
}
// end::class-ciphering[]
