package be.recipe.api.prescriber;

import be.recipe.api.Actor;
import be.recipe.api.Prescription;
import be.recipe.api.SSIN;
import be.recipe.api.crypto.Message;
import be.recipe.api.projections.SearchResult;
import java8.util.function.Function;

public interface Prescriber extends SearchResult.Prescriber {
  ID id();

  SSIN ssin();

  PrescriberType type();

  class ID extends Actor.ID {
    // end::structure[]
    protected ID(String value) {
      super(value);
    }

    public static ID prescriberID(String id) {
      return construct(
          id,
          new Function<String, ID>() {
            @Override
            public ID apply(String it) {
              return new ID(it);
            }
          });
    }
    // tag::structure[]
  }
  // end::structure[]

  class Simple implements Prescriber, Message.Cipher.Key.Owner<Prescription.OnContent> {
    private final ID id;
    private final PrescriberType type;
    public SSIN ssin;

    public static Prescriber.Simple prescriber(PrescriberType type, ID id) {
      return new Prescriber.Simple(id, type);
    }

    public Simple(ID id, PrescriberType type) {
      this.id = id;
      this.type = type;
    }

    public Simple(ID id, PrescriberType type, SSIN ssin) {
      this.id = id;
      this.type = type;
      this.ssin = ssin;
    }

    @Override
    public ID id() {
      return id;
    }

    @Override
    public SSIN ssin() {
      return ssin;
    }

    @Override
    public PrescriberType type() {
      return type;
    }

    @Override
    public void process(Prescription.OnContent processor) {
      processor.process(this);
    }
  }

  class Wrapper implements Prescriber {
    private final Prescriber target;

    public Wrapper(Prescriber target) {
      this.target = target;
    }

    @Override
    public ID id() {
      return target.id();
    }

    @Override
    public SSIN ssin() {
      return target.ssin();
    }

    @Override
    public PrescriberType type() {
      return target.type();
    }
  }
  // tag::structure[]
}
