package be.recipe.api.prescriber;

import be.recipe.api.Prescription;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

// tag::documented[]
public class CreatePrescription<T extends Prescription.Specification> {
  @NotNull @Valid public final T customizations;
  // end::documented[]

  public CreatePrescription(T customizations) {
    this.customizations = customizations;
  }
  // tag::documented[]

  public interface Command<
      S extends Prescription.Specification,
      R extends CreatePrescription<S>,
      P extends Prescription> {
    P add(R request);
  }
}
// end::documented[]
