package be.recipe.api.patient.constraints;

import be.recipe.api.patient.PutVisionExecutors;

import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static be.recipe.api.Prescription.vision_incompatible_with_reservation;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Inherited
@Documented
@Retention(RUNTIME)
@Target(TYPE)
@Constraint(validatedBy = CompatibleWithReservation.Validator.class)
public @interface CompatibleWithReservation {
  String message() default vision_incompatible_with_reservation;

  Class<?>[] groups() default {};

  Class<? extends Payload>[] payload() default {};

  interface Validator extends ConstraintValidator<CompatibleWithReservation, PutVisionExecutors.Request> {}
}
