package be.recipe.api.patient;

import be.recipe.api.Prescription;
import be.recipe.api.constraints.Constraint;

import javax.validation.constraints.NotNull;

public class RevokePrescription {
  @NotNull(message = Constraint.required)
  public Prescription.RID rid;

  public static RevokePrescription of(Prescription.RID rid) {
    return new RevokePrescription().rid(rid);
  }

  private RevokePrescription rid(Prescription.RID rid) {
    this.rid = rid;
    return this;
  }

  public interface Command<Request extends RevokePrescription> {
    void update(Request request);
  }
}
