package be.recipe.api.patient;

import static be.recipe.api.constraints.Constraint.required;

import be.recipe.api.Prescription;
import be.recipe.api.prescriber.VisionOtherPrescribers;
import javax.validation.constraints.NotNull;

// tag::feature[]
public class PutVisionOtherPrescribers {
  @NotNull(message = required)
  public Prescription.RID rid;

  @NotNull(message = required)
  public VisionOtherPrescribers vision;
  // end::feature[]

  public PutVisionOtherPrescribers() {}

  public PutVisionOtherPrescribers(Prescription.RID rid) {
    this.rid = rid;
  }

  public PutVisionOtherPrescribers(Prescription.RID rid, VisionOtherPrescribers vision) {
    this(rid);
    this.vision = vision;
  }

  public PutVisionOtherPrescribers(PutVisionOtherPrescribers from) {
    this(from.rid, from.vision);
  }
  // tag::feature[]

  public interface Command<Request extends PutVisionOtherPrescribers> {
    void update(Request request);
  }
}
// end::feature[]
