package be.recipe.api.patient;

public interface PrescriptionService<
        Prescription extends be.recipe.api.Prescription,
        ListPrescriptions extends be.recipe.api.patient.ListPrescriptions,
        ListPrescriptionsResponse extends be.recipe.api.patient.ListPrescriptions.Response,
        PutVisionExecutorsRequest extends be.recipe.api.patient.PutVisionExecutors.Request,
        GetExecutorProfile extends be.recipe.api.patient.GetExecutorProfile,
        GetExecutorProfileResponse extends be.recipe.api.patient.GetExecutorProfile.Response,
        GetPrescription extends be.recipe.api.patient.GetPrescription,
        GetPrescriptionStatus extends be.recipe.api.patient.GetPrescriptionStatus,
        GetPrescriptionStatusResponse extends be.recipe.api.GetPrescriptionStatusResponse,
        RevokePrescription extends be.recipe.api.patient.RevokePrescription,
        PutVisionOtherPrescribers extends be.recipe.api.patient.PutVisionOtherPrescribers>
    extends be.recipe.api.patient.ListPrescriptions.Command<
            ListPrescriptions, ListPrescriptionsResponse>,
        be.recipe.api.patient.PutVisionExecutors<PutVisionExecutorsRequest>,
        be.recipe.api.patient.GetExecutorProfile.Command<
            GetExecutorProfile, GetExecutorProfileResponse>,
        be.recipe.api.patient.GetPrescription.Command<GetPrescription, Prescription>,
        be.recipe.api.patient.RevokePrescription.Command<RevokePrescription>,
        be.recipe.api.patient.PutVisionOtherPrescribers.Command<PutVisionOtherPrescribers>,
        be.recipe.api.patient.GetPrescriptionStatus.Command<
            GetPrescriptionStatus, GetPrescriptionStatusResponse> {
  interface Simplified
      extends PrescriptionService<
              be.recipe.api.Prescription.Encrypted,
              be.recipe.api.patient.ListPrescriptions,
              be.recipe.api.patient.ListPrescriptions.Response.Encrypted,
              be.recipe.api.patient.PutVisionExecutors.Request,
              be.recipe.api.patient.GetExecutorProfile,
              be.recipe.api.patient.GetExecutorProfile.Response,
              be.recipe.api.patient.GetPrescription,
              be.recipe.api.patient.GetPrescriptionStatus,
              be.recipe.api.GetPrescriptionStatusResponse,
              be.recipe.api.patient.RevokePrescription,
              be.recipe.api.patient.PutVisionOtherPrescribers>,
          LockPrescription<LockPrescription.Request> {
    void lock(LockPrescription.Request from);

    void unlock(UnlockPrescription from);
  }

  interface Ciphering<
          ListPrescriptions extends be.recipe.api.patient.ListPrescriptions,
          PutVisionExecutorsRequest extends be.recipe.api.patient.PutVisionExecutors.Request,
          GetExecutorProfile extends be.recipe.api.patient.GetExecutorProfile,
          GetExecutorProfileResponse extends be.recipe.api.patient.GetExecutorProfile.Response,
          GetPrescription extends be.recipe.api.patient.GetPrescription>
      extends PrescriptionService<
              be.recipe.api.Prescription.PlainText,
              ListPrescriptions,
              be.recipe.api.patient.ListPrescriptions.Response.PlainText,
              PutVisionExecutorsRequest,
              GetExecutorProfile,
              GetExecutorProfileResponse,
              GetPrescription,
              be.recipe.api.patient.GetPrescriptionStatus,
              be.recipe.api.GetPrescriptionStatusResponse,
              be.recipe.api.patient.RevokePrescription,
              be.recipe.api.patient.PutVisionOtherPrescribers>,
          be.recipe.api.patient.GetPrescription.Command<
              GetPrescription, be.recipe.api.Prescription.PlainText> {
    interface Simplified
        extends Ciphering<
                be.recipe.api.patient.ListPrescriptions,
                be.recipe.api.patient.PutVisionExecutors.Request,
                be.recipe.api.patient.GetExecutorProfile,
                be.recipe.api.patient.GetExecutorProfile.Response,
                be.recipe.api.patient.GetPrescription>,
            LockPrescription<LockPrescription.Request>,
            UnlockPrescription.Command<UnlockPrescription> {
      void lock(LockPrescription.Request from);

      void unlock(UnlockPrescription from);
    }
  }
}
