package be.recipe.api.patient;

import be.recipe.api.Actor;
import be.recipe.api.Prescription;
import be.recipe.api.crypto.Message;
import java8.util.function.Function;

public interface Patient {
  ID id();

  class ID extends Actor.ID implements Message.Cipher.Key.Owner<Prescription.OnContent> {
    // end::structure[]
    private ID(String value) {
      super(value);
    }

    public static ID patientID(String it) {
      return construct(
          it,
          new Function<String, ID>() {
            @Override
            public ID apply(String it) {
              return new ID(it);
            }
          });
    }

    @Override
    public void process(Prescription.OnContent processor) {
      processor.process(this);
    }
    // tag::structure[]
  }

  // end::structure[]

  class Simple implements Patient {
    private final ID id;

    public Simple(ID id) {
      this.id = id;
    }

    @Override
    public ID id() {
      return id;
    }

    // Prefer ID.patientID instead. This method only exists because VB.NET can't access the ID type
    // due to its case-insensitive nature.
    @Deprecated
    public static ID patientID(String it) {
      return ID.patientID(it);
    }
  }
  // tag::structure[]
}
