package be.recipe.api.patient;

import be.recipe.api.Prescription;

import javax.validation.constraints.NotNull;

// tag::class[]
public interface LockPrescription<R extends LockPrescription.Request> {
  // end::class[]
  // tag::methods[]
  void lock(Request request);

  // end::methods[]
  // tag::class[]
  class Request {
    // end::class[]
    // tag::attributes[]
    @NotNull public Prescription.RID prescription;
    // end::attributes[]

    public static Request lock(Prescription.RID prescription) {
      return new Request(prescription);
    }

    public Request() {}

    public Request(Prescription.RID prescription) {
      this.prescription = prescription;
    }
    // tag::class[]
  }
}
// end::class[]
