package be.recipe.api.patient;

import be.recipe.api.Prescription;
import javax.validation.constraints.NotNull;

// tag::class[]
public class GetPrescription {
  // end::class[]
  // tag::attributes[]
  @NotNull public Prescription.RID rid;
  // end::attributes[]

  protected GetPrescription(Prescription.RID rid) {
    this.rid = rid;
  }

  public static GetPrescription of(Prescription.RID rid) {
    return new GetPrescription(rid);
  }
  // tag::class[]

  public interface Command<Request extends GetPrescription, Response extends Prescription> {
    Response get(Request request);
  }
}
// end::class[]
