package be.recipe.api.patient;

import static be.recipe.api.constraints.Constraint.required;

import be.recipe.api.ExecutorProfile;
import be.recipe.api.executor.Executor;
import javax.validation.constraints.NotNull;

// tag::feature[]
public class GetExecutorProfile {
  @NotNull(message = required)
  public final Executor.ID executorId;
  // end::feature[]

  private GetExecutorProfile(Executor.ID executorId) {
    this.executorId = executorId;
  }

  protected GetExecutorProfile(GetExecutorProfile target) {
    this(target.executorId);
  }

  public static GetExecutorProfile of(Executor.ID executorId) {
    return new GetExecutorProfile(executorId);
  }
  // tag::feature[]

  public interface Command<
      Request extends GetExecutorProfile, Response extends GetExecutorProfile.Response> {
    Response getProfile(Request request);
  }

  public interface Response extends GetReservationProfile.Response {
    // end::feature[]
    class Simple implements Response {
      private ExecutorProfile.ReservationFeature reservationFeature;
      private ExecutorProfile.CommunicationChannelSpecification communicationChannelSpecification;

      private Simple() {}

      public static Simple profile() {
        return new Simple();
      }

      @Override
      public ExecutorProfile.ReservationFeature reservationFeature() {
        return reservationFeature;
      }

      public Simple reservationFeature(ExecutorProfile.ReservationFeature reservationFeature) {
        this.reservationFeature = reservationFeature;
        return this;
      }

      @Override
      public ExecutorProfile.CommunicationChannelSpecification communicationChannelSpecification() {
        return communicationChannelSpecification;
      }

      public Simple communicationChannelSpecification(
          ExecutorProfile.CommunicationChannelSpecification communicationChannelSpecification) {
        this.communicationChannelSpecification = communicationChannelSpecification;
        return this;
      }
    }
    // tag::feature[]
  }
}
// end::feature[]
