package be.recipe.api.patient;

import be.recipe.api.Prescription;

import javax.validation.constraints.NotNull;

// tag::class[]
public class CancelReservation {
  // end::class[]
  // tag::attributes[]
  @NotNull public Prescription.RID rid;
  // end::attributes[]

  protected CancelReservation(Prescription.RID rid) {
    this.rid = rid;
  }

  public static CancelReservation of(Prescription.RID rid) {
    return new CancelReservation(rid);
  }
  // tag::class[]

  public interface Command<
      Request extends CancelReservation, Legacy extends CancelReservation.Legacy> {
    // end::class[]
    // tag::methods[]
    Response update(Request request);
    // end::methods[]

    // tag::legacy[]
    @Deprecated
    void update(Legacy request);
    // end::legacy[]
    // tag::class[]
  }
  // end::class[]
  // tag::legacy[]

  @Deprecated
  public static class Legacy extends CancelReservation {
    // end::legacy[]
    protected Legacy(Prescription.RID rid) {
      super(rid);
    }

    public static CancelReservation.Legacy of(Prescription.RID rid) {
      return new CancelReservation.Legacy(rid);
    }
    // tag::legacy[]
  }
  // end::legacy[]
  // tag::response[]

  public interface Response {}
  // end::response[]
  // tag::class[]
}
// end::class[]
