package be.recipe.api.patient;

import be.recipe.api.Prescription;
import be.recipe.api.executor.Executor;
import be.recipe.api.reservation.ContactPreference;

import javax.validation.constraints.NotNull;

import static be.recipe.api.constraints.Constraint.required;

// tag::class[]
public class AddReservation {
  // end::class[]
  // tag::methods[]
  @NotNull(message = required)
  public Prescription.RID rid;

  @NotNull(message = required)
  public Executor.ID executorId;

  public String email;
  public String phoneNumber;
  public ContactPreference contactPreference;
  // end::methods[]
  // tag::class[]

  public interface Command<R extends AddReservation, L extends AddReservation> {
    // end::class[]
    // tag::methods[]
    void add(R request);
    // end::methods[]

    // tag::legacy[]
    @Deprecated
    void addLegacy(L request);
    // end::legacy[]
    // tag::class[]
  }
  // end::class[]

  public static AddReservation request() {
    return new AddReservation();
  }

  public AddReservation rid(Prescription.RID rid) {
    this.rid = rid;
    return this;
  }

  public AddReservation executorId(Executor.ID executorId) {
    this.executorId = executorId;
    return this;
  }

  public AddReservation email(String email) {
    this.email = email;
    return this;
  }

  public AddReservation phoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  public AddReservation contactPreference(ContactPreference contactPreference) {
    this.contactPreference = contactPreference;
    return this;
  }
  // tag::class[]
}
// end::class[]
