package be.recipe.api.mandate;

import be.recipe.api.patient.Patient;

public interface MandateGiver {
  Patient.ID id();

  String firstName();

  String lastName();

  class Simple implements MandateGiver {
    private Patient.ID id;
    private String firstName, lastName;

    @Override
    public Patient.ID id() {
      return id;
    }

    @Override
    public String firstName() {
      return firstName;
    }

    @Override
    public String lastName() {
      return lastName;
    }

    public static Simple mandateGiver(Patient.ID id) {
      return new MandateGiver.Simple().id(id);
    }

    public Simple id(Patient.ID id) {
      this.id = id;
      return this;
    }

    public Simple firstName(String firstName) {
      this.firstName = firstName;
      return this;
    }

    public Simple lastName(String lastName) {
      this.lastName = lastName;
      return this;
    }
  }
}
