package be.recipe.api.executor;

import be.recipe.api.Prescription;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

// tag::feature[]
public class RejectReservation {
  @NotNull public Prescription.RID rid;

  @Size(max = 500)
  public String message;
  // end::feature[]

  public static RejectReservation of(Prescription.RID rid) {
    return new RejectReservation().rid(rid);
  }

  public RejectReservation rid(Prescription.RID rid) {
    this.rid = rid;
    return this;
  }

  public RejectReservation message(String message) {
    this.message = message;
    return this;
  }
  // tag::feature[]

  public interface Command<Request extends RejectReservation> {
    void update(Request request);
  }
}
// end::feature[]
