package be.recipe.api.executor;

import be.recipe.api.ExecutorProfile;

// tag::feature[]
public class GetProfile {
  // end::feature[]
  private GetProfile() {}

  protected GetProfile(GetProfile target) {}

  public static GetProfile request() {
    return new GetProfile();
  }

  // tag::feature[]
  public interface Command<Request extends GetProfile, Response extends GetProfile.Response> {
    Response getProfile(Request request);
  }

  public interface Response {
    ExecutorProfile.ReservationFeature reservationFeature();

    ExecutorProfile.CommunicationChannelSpecification communicationChannelSpecification();
    // end::feature[]

    class Simple implements Response {
      private ExecutorProfile.CommunicationChannelSpecification communicationChannelSpecification;
      private ExecutorProfile.ReservationFeature reservationFeature;

      private Simple() {}

      public static Simple profile() {
        return new Simple();
      }

      @Override
      public ExecutorProfile.ReservationFeature reservationFeature() {
        return reservationFeature;
      }

      public Simple reservationFeature(ExecutorProfile.ReservationFeature reservationFeature) {
        this.reservationFeature = reservationFeature;
        return this;
      }

      @Override
      public ExecutorProfile.CommunicationChannelSpecification communicationChannelSpecification() {
        return communicationChannelSpecification;
      }

      public Simple communicationChannelSpecification(
          ExecutorProfile.CommunicationChannelSpecification communicationChannelSpecification) {
        this.communicationChannelSpecification = communicationChannelSpecification;
        return this;
      }
    }
    // tag::feature[]
  }
}
// end::feature[]
