package be.recipe.api.executor;

import be.recipe.api.Actor;
import be.recipe.api.Prescription;
import be.recipe.api.crypto.Message;
import be.recipe.api.text.ExtendableString;
import java8.util.function.Function;

public interface Executor {
  ID id();

  Type type();

  class ID extends Actor.ID implements Message.Cipher.Key.Owner<Prescription.OnContent> {
    // end::structure[]
    protected ID(String value) {
      super(value);
    }

    @Override
    public void process(Prescription.OnContent processor) {
      processor.process(this);
    }

    public static ID executorId(String it) {
      return construct(
          it,
          new Function<String, ID>() {
            @Override
            public ID apply(String it) {
              return new ID(it);
            }
          });
    }
    // tag::structure[]
  }
  // end::structure[]

  // tag::structure[]
  class Type extends ExtendableString {
    // end::structure[]
    private Type(String value) {
      super(value);
    }

    public static Type executorType(String it) {
      return construct(
          it,
          new Function<String, Type>() {
            @Override
            public Type apply(String it) {
              return new Type(it);
            }
          });
    }
    // tag::structure[]
  }
  // end::structure[]

  class All implements Message.Cipher.Key.Owner<Prescription.OnContent> {
    public static All all() {
      return new All();
    }

    @Override
    public void process(Prescription.OnContent processor) {
      processor.process(this);
    }

    @Override
    public String toString() {
      return getClass().getName();
    }

    @Override
    public boolean equals(Object it) {
      return it instanceof ID;
    }
  }

  class Simple implements Executor {
    private Type type;
    private ID id;

    public Simple() {}

    public Simple(ID id) {
      this(id, null);
    }

    public Simple(ID id, Type type) {
      this.id = id;
      this.type = type;
    }

    public void setId(ID id) {
      this.id = id;
    }

    @Override
    public ID id() {
      return id;
    }

    @Override
    public Type type() {
      return type;
    }
  }
  // tag::structure[]
}
