package be.recipe.api.executor;

import be.recipe.api.Prescription;

import javax.validation.constraints.NotNull;

// tag::feature[]
public class AcceptReservationCancellationRequest {
  @NotNull public Prescription.RID rid;
  // end::feature[]

  public static AcceptReservationCancellationRequest of(Prescription.RID rid) {
    return new AcceptReservationCancellationRequest().rid(rid);
  }

  private AcceptReservationCancellationRequest rid(Prescription.RID rid) {
    this.rid = rid;
    return this;
  }
  // tag::feature[]

  public interface Command<Request extends AcceptReservationCancellationRequest> {
    void update(Request request);
  }
}
// end::feature[]
