package be.recipe.api.constraints;

import be.recipe.api.patient.Patient;

import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Documented
@Retention(RUNTIME)
@Target({TYPE, FIELD})
@Constraint(validatedBy = SSIN.Validator.class)
public @interface SSIN {
  // tag::constraints[]
  String invalid_ssin_format = "invalid.ssin.format";
  // end::constraints[]

  String message() default invalid_ssin_format;

  Class<?>[] groups() default {};

  Class<? extends Payload>[] payload() default {};

  interface Validator extends ConstraintValidator<SSIN, Patient.ID> {}
}
