package be.recipe.api.constraints;

import be.recipe.api.prescriber.Prescriber;

import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Documented
@Retention(RUNTIME)
@Target({TYPE, FIELD})
@Constraint(validatedBy = PrescriberAllowed.Validator.class)
public @interface PrescriberAllowed {
  // tag::constraints[]
  String PRESCRIBER_NOT_ALLOWED = "error.permission.required.to.prescribe.medication";
  // end::constraints[]

  String message() default PRESCRIBER_NOT_ALLOWED;

  Class<?>[] groups() default {};

  Class<? extends Payload>[] payload() default {};

  interface Validator extends ConstraintValidator<PrescriberAllowed, Prescriber> {}
}
