package be.recipe.api.constraints;

import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Map;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Inherited
@Documented
@Retention(RUNTIME)
@Target({TYPE, FIELD})
@Constraint(validatedBy = Known.Validator.class)
public @interface Known {
  String message() default "unknown";

  Class<?>[] groups() default {};

  Class<? extends Payload>[] payload() default {};

  interface Validator extends ConstraintValidator<Known, Object> {}

  class RoutingValidator implements Validator {
    private final Map<Class<?>, Validator> map;

    public RoutingValidator(Map<Class<?>, Validator> map) {
      this.map = map;
    }

    @Override
    public boolean isValid(Object it, ConstraintValidatorContext context) {
      if (map.containsKey(it.getClass())) return map.get(it.getClass()).isValid(it, context);
      else throw new IllegalArgumentException("No validator found for " + it.getClass() + "!");
    }
  }
}
