package be.recipe.api;

import java8.util.function.Function;

// tag::class[]
public interface Registered {
  Prescription.RID rid();

  class Simple {
    public static Function<Registered, Prescription.RID> toRID() {
      return new Function<Registered, Prescription.RID>() {
        @Override
        public Prescription.RID apply(Registered it) {
          return it.rid();
        }
      };
    }
  }
}
// end::class[]
