package be.recipe.api;

import be.recipe.api.crypto.Message;
import be.recipe.api.reservation.ReservationService;

public class Recipe {
  private final Infrastructure infrastructure;

  public Recipe(Infrastructure infrastructure) {
    this.infrastructure = infrastructure;
  }

  public PrescriptionService.Ciphering.Simplified cipheringPrescriptionService() {
    return new PrefetchingPrescriptionService(
        new CipheringPrescriptionService(
            new ArchivingPrescriptionService(
                infrastructure.prescriptionService(),
                infrastructure.timestampingContext(),
                prescriptionContentFactory()),
            prescriptionContentFactory()));
  }

  public ReservationService.Simplified reservationService() {
    return infrastructure.reservationService();
  }

  public MandateService.Simplified mandateService() {
    return infrastructure.mandateService();
  }

  public PrescriptionContent.Factory prescriptionContentFactory() {
    // tag::prescription-content-factory[]
    PrescriptionContent.Factory factory =
        new PrescriptionContent.Factory(
            new Message.Factory(infrastructure.cipher(), infrastructure.timestampingContext()),
            infrastructure.keyRegistry());
    // end::prescription-content-factory[]
    return factory;
  }

  public interface Infrastructure {
    PrescriptionService.Simplified prescriptionService();

    Message.Cipher cipher();

    Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry();

    Message.Encrypted.Timestamped.Extractor timestampingContext();

    ReservationService.Simplified reservationService();

    MandateService.Simplified mandateService();
  }
}
