package be.recipe.api;

import be.recipe.api.executor.*;
import be.recipe.api.executor.ListPrescriptions;
import be.recipe.api.patient.*;
import be.recipe.api.prescriber.CreatePrescription;
import be.recipe.api.series.PartialResult;

public interface PrescriptionService<
        Prescription extends be.recipe.api.Prescription,
        GetPrescriptionStatusResponse extends be.recipe.api.GetPrescriptionStatusResponse,
        ListPrescriptionsPrescriber extends be.recipe.api.prescriber.ListPrescriptions,
        ListPrescriptionsPrescriberResponse extends
            be.recipe.api.prescriber.ListPrescriptions.Response,
        ListPrescriptionsExecutor extends be.recipe.api.executor.ListPrescriptions,
        ListPrescriptionsExecutorResponse extends be.recipe.api.executor.ListPrescriptions.Response,
        ListPrescriptionsPatient extends be.recipe.api.patient.ListPrescriptions,
        ListPrescriptionsPatientResponse extends be.recipe.api.patient.ListPrescriptions.Response,
        GetPrescriptionPrescriber extends be.recipe.api.prescriber.GetPrescription,
        GetPrescriptionStatusPrescriber extends be.recipe.api.prescriber.GetPrescriptionStatus,
        GetPrescriptionStatusExecutor extends be.recipe.api.executor.GetPrescriptionStatus,
        GetPrescriptionsExecutor extends be.recipe.api.executor.GetPrescription,
        GetPrescriptionAndPutInProcessExecutor extends
            be.recipe.api.executor.GetPrescriptionAndPutInProcess,
        SpecificationPrescription extends be.recipe.api.Prescription.Specification,
        CreatePrescriptionPrescriber extends
            be.recipe.api.prescriber.CreatePrescription<SpecificationPrescription>,
        PutVisionPatientRequest extends be.recipe.api.patient.PutVisionExecutors.Request,
        PutVisionOtherPrescribersPrescriber extends
            be.recipe.api.prescriber.PutVisionOtherPrescribers,
        GetExecutorProfilePatient extends be.recipe.api.patient.GetExecutorProfile,
        GetExecutorProfilePatientResponse extends be.recipe.api.patient.GetExecutorProfile.Response,
        UpdateProfileExecutor extends be.recipe.api.executor.UpdateProfile,
        GetProfileExecutor extends be.recipe.api.executor.GetProfile,
        GetProfileExecutorResponse extends be.recipe.api.executor.GetProfile.Response,
        GetPrescriptionPatient extends be.recipe.api.patient.GetPrescription,
        GetPrescriptionStatusPatient extends be.recipe.api.patient.GetPrescriptionStatus,
        RevokePrescriptionPrescriber extends be.recipe.api.prescriber.RevokePrescription,
        RevokePrescriptionPatient extends be.recipe.api.patient.RevokePrescription,
        ArchivePrescriptionExecutor extends be.recipe.api.executor.ArchivePrescription,
        PutVisionOtherPrescribersPatient extends PutVisionOtherPrescribers>
    extends be.recipe.api.prescriber.PrescriptionService<
            Prescription,
            GetPrescriptionStatusResponse,
            ListPrescriptionsPrescriber,
            ListPrescriptionsPrescriberResponse,
            GetPrescriptionPrescriber,
            GetPrescriptionStatusPrescriber,
            SpecificationPrescription,
            CreatePrescriptionPrescriber,
            PutVisionOtherPrescribersPrescriber,
            RevokePrescriptionPrescriber>,
        be.recipe.api.executor.PrescriptionService<
            Prescription,
            GetPrescriptionsExecutor,
            GetPrescriptionAndPutInProcessExecutor,
            ListPrescriptionsExecutor,
            ListPrescriptionsExecutorResponse,
            UpdateProfileExecutor,
            GetProfileExecutor,
            GetProfileExecutorResponse,
            ArchivePrescriptionExecutor,
            GetPrescriptionStatusExecutor,
            GetPrescriptionStatusResponse>,
        be.recipe.api.patient.PrescriptionService<
            Prescription,
            ListPrescriptionsPatient,
            ListPrescriptionsPatientResponse,
            PutVisionPatientRequest,
            GetExecutorProfilePatient,
            GetExecutorProfilePatientResponse,
            GetPrescriptionPatient,
            GetPrescriptionStatusPatient,
            GetPrescriptionStatusResponse,
            RevokePrescriptionPatient,
            PutVisionOtherPrescribersPatient> {

  interface Simplified
      extends PrescriptionService<
          be.recipe.api.Prescription.Encrypted,
          be.recipe.api.GetPrescriptionStatusResponse,
          be.recipe.api.prescriber.ListPrescriptions,
          be.recipe.api.prescriber.ListPrescriptions.Response.Encrypted,
          be.recipe.api.executor.ListPrescriptions,
          be.recipe.api.executor.ListPrescriptions.Response.Encrypted,
          be.recipe.api.patient.ListPrescriptions,
          be.recipe.api.patient.ListPrescriptions.Response.Encrypted,
          be.recipe.api.prescriber.GetPrescription,
          be.recipe.api.prescriber.GetPrescriptionStatus,
          be.recipe.api.executor.GetPrescriptionStatus,
          be.recipe.api.executor.GetPrescription,
          be.recipe.api.executor.GetPrescriptionAndPutInProcess,
          be.recipe.api.Prescription.Encrypted.Specification,
          be.recipe.api.prescriber.CreatePrescription<
              be.recipe.api.Prescription.Encrypted.Specification>,
          be.recipe.api.patient.PutVisionExecutors.Request,
          be.recipe.api.prescriber.PutVisionOtherPrescribers,
          be.recipe.api.patient.GetExecutorProfile,
          be.recipe.api.patient.GetExecutorProfile.Response,
          be.recipe.api.executor.UpdateProfile,
          be.recipe.api.executor.GetProfile,
          be.recipe.api.executor.GetProfile.Response,
          be.recipe.api.patient.GetPrescription,
          be.recipe.api.patient.GetPrescriptionStatus,
          be.recipe.api.prescriber.RevokePrescription,
          be.recipe.api.patient.RevokePrescription,
          be.recipe.api.executor.ArchivePrescription,
          PutVisionOtherPrescribers> {
    class Wrapper implements PrescriptionService.Simplified {
      private final PrescriptionService.Simplified target;

      public Wrapper(PrescriptionService.Simplified target) {
        this.target = target;
      }

      @Override
      public void update(ArchivePrescription request) {
        target.update(request);
      }

      @Override
      public be.recipe.api.Prescription.Encrypted get(
          be.recipe.api.executor.GetPrescription request) {
        return target.get(request);
      }

      @Override
      public be.recipe.api.Prescription.Encrypted getAndPutInProcess(
          GetPrescriptionAndPutInProcess request) {
        return target.getAndPutInProcess(request);
      }

      @Override
      public be.recipe.api.GetPrescriptionStatusResponse get(
          be.recipe.api.executor.GetPrescriptionStatus request) {
        return target.get(request);
      }

      @Override
      public GetProfile.Response getProfile(GetProfile request) {
        return target.getProfile(request);
      }

      @Override
      public PartialResult<be.recipe.api.executor.ListPrescriptions.Response.Encrypted> list(be.recipe.api.executor.ListPrescriptions request) {
        return target.list(request);
      }

      @Override
      public void updateProfile(UpdateProfile request) {
        target.updateProfile(request);
      }

      @Override
      public GetExecutorProfile.Response getProfile(GetExecutorProfile request) {
        return target.getProfile(request);
      }

      @Override
      public be.recipe.api.Prescription.Encrypted get(
          be.recipe.api.patient.GetPrescription request) {
        return target.get(request);
      }

      @Override
      public PartialResult<be.recipe.api.patient.ListPrescriptions.Response.Encrypted> list(be.recipe.api.patient.ListPrescriptions request) {
        return target.list(request);
      }

      @Override
      public void update(PutVisionExecutors.Request request) {
        target.update(request);
      }

      @Override
      public void update(PutVisionOtherPrescribers request) {
        target.update(request);
      }

      @Override
      public void update(RevokePrescription request) {
        target.update(request);
      }

      @Override
      public be.recipe.api.Prescription.Encrypted add(
          CreatePrescription<be.recipe.api.Prescription.Encrypted.Specification> request) {
        return target.add(request);
      }

      @Override
      public be.recipe.api.Prescription.Encrypted get(
          be.recipe.api.prescriber.GetPrescription request) {
        return target.get(request);
      }

      @Override
      public be.recipe.api.GetPrescriptionStatusResponse get(
          be.recipe.api.prescriber.GetPrescriptionStatus request) {
        return target.get(request);
      }

      @Override
      public be.recipe.api.prescriber.ListPrescriptions.PartialResult<be.recipe.api.prescriber.ListPrescriptions.Response.Encrypted>
          list(be.recipe.api.prescriber.ListPrescriptions request) {
        return target.list(request);
      }

      @Override
      public void update(be.recipe.api.prescriber.PutVisionOtherPrescribers request) {
        target.update(request);
      }

      @Override
      public void update(be.recipe.api.prescriber.RevokePrescription request) {
        target.update(request);
      }

      @Override
      public be.recipe.api.GetPrescriptionStatusResponse get(
          be.recipe.api.patient.GetPrescriptionStatus request) {
        return target.get(request);
      }
    }
  }

  interface Ciphering<
          ListPrescriptionsPrescriber extends be.recipe.api.prescriber.ListPrescriptions,
          ListPrescriptionsExecutor extends be.recipe.api.executor.ListPrescriptions,
          GetPrescriptionPrescriber extends be.recipe.api.prescriber.GetPrescription,
          GetPrescriptionStatusPrescriber extends be.recipe.api.prescriber.GetPrescriptionStatus,
          ListPrescriptionsPatient extends be.recipe.api.patient.ListPrescriptions,
          GetPrescriptionExecutor extends be.recipe.api.executor.GetPrescription,
          GetPrescriptionAndPutInProcessExecutor extends
              be.recipe.api.executor.GetPrescriptionAndPutInProcess,
          CreatePrescriptionPrescriber extends
              be.recipe.api.prescriber.CreatePrescription<
                      be.recipe.api.Prescription.PlainText.Specification>,
          PutVisionPatientRequest extends be.recipe.api.patient.PutVisionExecutors.Request,
          GetExecutorProfilePatient extends be.recipe.api.patient.GetExecutorProfile,
          GetExecutorProfilePatientResponse extends
              be.recipe.api.patient.GetExecutorProfile.Response,
          UpdateProfileExecutor extends be.recipe.api.executor.UpdateProfile,
          GetProfileExecutor extends be.recipe.api.executor.GetProfile,
          GetProfileExecutorResponse extends be.recipe.api.executor.GetProfile.Response,
          GetPrescriptionPatient extends be.recipe.api.patient.GetPrescription,
          ArchivePrescriptionExecutor extends be.recipe.api.executor.ArchivePrescription>
      extends PrescriptionService<
              be.recipe.api.Prescription.PlainText,
              be.recipe.api.GetPrescriptionStatusResponse,
              ListPrescriptionsPrescriber,
              be.recipe.api.prescriber.ListPrescriptions.Response.PlainText,
              ListPrescriptionsExecutor,
              be.recipe.api.executor.ListPrescriptions.Response.PlainText,
              ListPrescriptionsPatient,
              be.recipe.api.patient.ListPrescriptions.Response.PlainText,
              GetPrescriptionPrescriber,
              be.recipe.api.prescriber.GetPrescriptionStatus,
              be.recipe.api.executor.GetPrescriptionStatus,
              GetPrescriptionExecutor,
              GetPrescriptionAndPutInProcessExecutor,
              be.recipe.api.Prescription.PlainText.Specification,
              CreatePrescriptionPrescriber,
              PutVisionPatientRequest,
              be.recipe.api.prescriber.PutVisionOtherPrescribers,
              GetExecutorProfilePatient,
              GetExecutorProfilePatientResponse,
              UpdateProfileExecutor,
              GetProfileExecutor,
              GetProfileExecutorResponse,
              GetPrescriptionPatient,
              be.recipe.api.patient.GetPrescriptionStatus,
              be.recipe.api.prescriber.RevokePrescription,
              be.recipe.api.patient.RevokePrescription,
              ArchivePrescriptionExecutor,
              PutVisionOtherPrescribers>,
          be.recipe.api.prescriber.PrescriptionService.Ciphering<
              ListPrescriptionsPrescriber, GetPrescriptionPrescriber, CreatePrescriptionPrescriber>,
          be.recipe.api.executor.PrescriptionService.Ciphering<
              ListPrescriptionsExecutor,
              GetPrescriptionExecutor,
              GetPrescriptionAndPutInProcessExecutor,
              UpdateProfileExecutor,
              GetProfileExecutor,
              GetProfileExecutorResponse,
              ArchivePrescriptionExecutor>,
          be.recipe.api.patient.PrescriptionService.Ciphering<
              ListPrescriptionsPatient,
              PutVisionPatientRequest,
              GetExecutorProfilePatient,
              GetExecutorProfilePatientResponse,
              GetPrescriptionPatient> {
    interface Simplified
        extends PrescriptionService.Ciphering<
                be.recipe.api.prescriber.ListPrescriptions,
                be.recipe.api.executor.ListPrescriptions,
                be.recipe.api.prescriber.GetPrescription,
                be.recipe.api.prescriber.GetPrescriptionStatus,
                be.recipe.api.patient.ListPrescriptions,
                be.recipe.api.executor.GetPrescription,
                be.recipe.api.executor.GetPrescriptionAndPutInProcess,
                be.recipe.api.prescriber.CreatePrescription<
                    be.recipe.api.Prescription.PlainText.Specification>,
                be.recipe.api.patient.PutVisionExecutors.Request,
                be.recipe.api.patient.GetExecutorProfile,
                be.recipe.api.patient.GetExecutorProfile.Response,
                be.recipe.api.executor.UpdateProfile,
                be.recipe.api.executor.GetProfile,
                be.recipe.api.executor.GetProfile.Response,
                be.recipe.api.patient.GetPrescription,
                be.recipe.api.executor.ArchivePrescription>,
            be.recipe.api.prescriber.PrescriptionService.Ciphering.Simplified,
            be.recipe.api.executor.PrescriptionService.Ciphering.Simplified,
            be.recipe.api.patient.PrescriptionService.Ciphering.Simplified {
      abstract class Abstract implements PrescriptionService.Ciphering.Simplified {
        @Override
        public void lock(LockPrescription.Request from) {
          Dispatcher.lock(from, this);
        }

        @Override
        public void unlock(be.recipe.api.patient.UnlockPrescription from) {
          Dispatcher.unlock(from, this);
        }
      }

      class Wrapper extends Abstract {
        protected final PrescriptionService.Ciphering.Simplified target;

        public Wrapper(PrescriptionService.Ciphering.Simplified target) {
          this.target = target;
        }

        @Override
        public PartialResult<be.recipe.api.patient.ListPrescriptions.Response.PlainText>
            list(be.recipe.api.patient.ListPrescriptions request) {
          return target.list(request);
        }

        @Override
        public void update(be.recipe.api.patient.PutVisionExecutors.Request request) {
          target.update(request);
        }

        @Override
        public be.recipe.api.prescriber.ListPrescriptions.PartialResult<
                be.recipe.api.prescriber.ListPrescriptions.Response.PlainText>
            list(be.recipe.api.prescriber.ListPrescriptions request) {
          return target.list(request);
        }

        @Override
        public be.recipe.api.Prescription.PlainText add(
            be.recipe.api.prescriber.CreatePrescription<
                    be.recipe.api.Prescription.PlainText.Specification>
                request) {
          return target.add(request);
        }

        @Override
        public be.recipe.api.Prescription.PlainText get(
            be.recipe.api.prescriber.GetPrescription request) {
          return target.get(request);
        }

        @Override
        public be.recipe.api.Prescription.PlainText get(
            be.recipe.api.executor.GetPrescription request) {
          return target.get(request);
        }

        @Override
        public be.recipe.api.Prescription.PlainText getAndPutInProcess(
            be.recipe.api.executor.GetPrescriptionAndPutInProcess request) {
          return target.getAndPutInProcess(request);
        }

        @Override
        public be.recipe.api.series.PartialResult<
                be.recipe.api.executor.ListPrescriptions.Response.PlainText>
            list(be.recipe.api.executor.ListPrescriptions request) {
          return target.list(request);
        }

        @Override
        public void update(be.recipe.api.prescriber.PutVisionOtherPrescribers request) {
          target.update(request);
        }

        @Override
        public be.recipe.api.patient.GetExecutorProfile.Response getProfile(
            be.recipe.api.patient.GetExecutorProfile request) {
          return target.getProfile(request);
        }

        @Override
        public void updateProfile(be.recipe.api.executor.UpdateProfile request) {
          target.updateProfile(request);
        }

        @Override
        public be.recipe.api.executor.GetProfile.Response getProfile(
            be.recipe.api.executor.GetProfile request) {
          return target.getProfile(request);
        }

        @Override
        public void update(be.recipe.api.prescriber.RevokePrescription request) {
          target.update(request);
        }

        @Override
        public void update(be.recipe.api.executor.ArchivePrescription request) {
          target.update(request);
        }

        @Override
        public void update(be.recipe.api.patient.RevokePrescription request) {
          target.update(request);
        }

        @Override
        public void update(PutVisionOtherPrescribers request) {
          target.update(request);
        }

        @Override
        public be.recipe.api.GetPrescriptionStatusResponse get(
            be.recipe.api.prescriber.GetPrescriptionStatus request) {
          return target.get(request);
        }

        @Override
        public be.recipe.api.GetPrescriptionStatusResponse get(
            be.recipe.api.executor.GetPrescriptionStatus request) {
          return target.get(request);
        }

        @Override
        public be.recipe.api.GetPrescriptionStatusResponse get(
            be.recipe.api.patient.GetPrescriptionStatus request) {
          return target.get(request);
        }

        @Override
        public be.recipe.api.Prescription.PlainText get(
            be.recipe.api.patient.GetPrescription request) {
          return target.get(request);
        }
      }
    }
  }
}
