package be.recipe.api;

import static java8.util.stream.StreamSupport.stream;

import be.recipe.api.crypto.Cipher;
import be.recipe.api.executor.ListPrescriptions;
import be.recipe.api.series.PartialResult;
import java.util.List;
import java.util.concurrent.*;
import java8.util.function.Function;
import java8.util.function.Supplier;
import java8.util.stream.Collectors;
import java8.util.stream.Stream;

public class PrefetchingPrescriptionService
    extends PrescriptionService.Ciphering.Simplified.Wrapper {
  private static final ExecutorService threadpool = Executors.newFixedThreadPool(10);

  public PrefetchingPrescriptionService(PrescriptionService.Ciphering.Simplified target) {
    super(target);
  }

  @Override
  @SuppressWarnings({"rawtypes", "unchecked"})
  public be.recipe.api.prescriber.ListPrescriptions.PartialResult<
          be.recipe.api.prescriber.ListPrescriptions.Response.PlainText>
      list(be.recipe.api.prescriber.ListPrescriptions request) {
    final be.recipe.api.prescriber.ListPrescriptions.PartialResult<
            be.recipe.api.prescriber.ListPrescriptions.Response.PlainText>
        target = super.list(request);
    return be.recipe.api.prescriber.ListPrescriptions.PartialResult.Simple.wrap(
        target,
        new Supplier<
            PartialResult<be.recipe.api.prescriber.ListPrescriptions.Response.PlainText>>() {
          @Override
          public PartialResult<be.recipe.api.prescriber.ListPrescriptions.Response.PlainText>
              get() {
            return (PartialResult)
                PartialResult.Simple.of(PrefetchedListPrescriptionsAsPrescriberItem.stream(target))
                    .hasMore(target.hasMore());
          }
        });
  }

  @Override
  public be.recipe.api.series.PartialResult<
          be.recipe.api.executor.ListPrescriptions.Response.PlainText>
      list(final be.recipe.api.executor.ListPrescriptions request) {
    return PartialResult.Simple.of(
        new Supplier<Stream<be.recipe.api.executor.ListPrescriptions.Response.PlainText>>() {
          @Override
          public Stream<be.recipe.api.executor.ListPrescriptions.Response.PlainText> get() {
            return prefetch(
                target.list(request).stream(),
                new Function<
                    be.recipe.api.executor.ListPrescriptions.Response.PlainText,
                    ListPrescriptions.Response.PlainText>() {
                  @Override
                  public be.recipe.api.executor.ListPrescriptions.Response.PlainText apply(
                      be.recipe.api.executor.ListPrescriptions.Response.PlainText plainText) {
                    return new PrefetchedListPrescriptionsAsExecutorItem(plainText);
                  }
                });
          }
        });
  }

  @Override
  public be.recipe.api.series.PartialResult<
          be.recipe.api.patient.ListPrescriptions.Response.PlainText>
      list(final be.recipe.api.patient.ListPrescriptions request) {
    return PartialResult.Simple.of(
        new Supplier<Stream<be.recipe.api.patient.ListPrescriptions.Response.PlainText>>() {
          @Override
          public Stream<be.recipe.api.patient.ListPrescriptions.Response.PlainText> get() {
            return prefetch(
                target.list(request).stream(),
                new Function<
                    be.recipe.api.patient.ListPrescriptions.Response.PlainText,
                    be.recipe.api.patient.ListPrescriptions.Response.PlainText>() {
                  @Override
                  public be.recipe.api.patient.ListPrescriptions.Response.PlainText apply(
                      be.recipe.api.patient.ListPrescriptions.Response.PlainText plainText) {
                    return new PrefetchedListPrescriptionsAsPatientItem(plainText);
                  }
                });
          }
        });
  }

  @SuppressWarnings({"unchecked", "rawtypes"})
  private static <F, T> Stream<T> prefetch(final Stream<F> stream, Function<F, T> transformer) {
    return stream((List) stream.map(toFuture(transformer)).collect(Collectors.toList()))
        .map(
            new Function<Future<T>, T>() {
              @Override
              public T apply(Future<T> future) {
                try {
                  return future.get();
                } catch (InterruptedException e) {
                  throw new RuntimeException(e);
                } catch (ExecutionException e) {
                  throw new RuntimeException(e);
                }
              }
            });
  }

  private static <F, T> Function<F, Future<T>> toFuture(final Function<F, T> factory) {
    return new Function<F, Future<T>>() {
      @Override
      public Future<T> apply(final F prescription) {
        return threadpool.submit(
            new Callable<T>() {
              @Override
              public T call() throws Exception {
                return factory.apply(prescription);
              }
            });
      }
    };
  }

  private static class PrefetchedListPrescriptionsAsPrescriberItem
      extends be.recipe.api.prescriber.ListPrescriptions.Response.PlainText.Wrapper {
    private String prescriptionContent = "non decipherable";
    private Cipher.Undecipherable exception;

    public PrefetchedListPrescriptionsAsPrescriberItem(PlainText target) {
      super(target);
      try {
        prescriptionContent = target.prescriptionContent();
      } catch (Cipher.Undecipherable e) {
        exception = e;
      }
    }

    @Override
    public String prescriptionContent() {
      if (exception != null) {
        throw exception;
      }
      return prescriptionContent;
    }

    public static Supplier<Stream<PrefetchedListPrescriptionsAsPrescriberItem>> stream(
        final be.recipe.api.prescriber.ListPrescriptions.PartialResult<PlainText> target) {
      return new Supplier<Stream<PrefetchedListPrescriptionsAsPrescriberItem>>() {
        @Override
        public Stream<PrefetchedListPrescriptionsAsPrescriberItem> get() {
          return prefetch(target.stream(), PrefetchedListPrescriptionsAsPrescriberItem.wrap());
        }
      };
    }

    public static Function<
            be.recipe.api.prescriber.ListPrescriptions.Response.PlainText,
            PrefetchedListPrescriptionsAsPrescriberItem>
        wrap() {
      return new Function<
          be.recipe.api.prescriber.ListPrescriptions.Response.PlainText,
          PrefetchedListPrescriptionsAsPrescriberItem>() {
        @Override
        public PrefetchedListPrescriptionsAsPrescriberItem apply(
            be.recipe.api.prescriber.ListPrescriptions.Response.PlainText plainText) {
          return new PrefetchedListPrescriptionsAsPrescriberItem(plainText);
        }
      };
    }
  }

  private static class PrefetchedListPrescriptionsAsExecutorItem
      extends be.recipe.api.executor.ListPrescriptions.Response.PlainText.Wrapper {
    private String prescriptionContent = "non decipherable";
    private Cipher.Undecipherable exception;

    public PrefetchedListPrescriptionsAsExecutorItem(PlainText target) {
      super(target);
      try {
        prescriptionContent = target.prescriptionContent();
      } catch (Cipher.Undecipherable e) {
        exception = e;
      }
    }

    @Override
    public String prescriptionContent() {
      if (exception != null) {
        throw exception;
      }
      return prescriptionContent;
    }
  }

  private static class PrefetchedListPrescriptionsAsPatientItem
      extends be.recipe.api.patient.ListPrescriptions.Response.PlainText.Wrapper {
    private String prescriptionContent = "non decipherable";
    private Cipher.Undecipherable exception;

    public PrefetchedListPrescriptionsAsPatientItem(PlainText target) {
      super(target);
      try {
        prescriptionContent = target.prescriptionContent();
      } catch (Cipher.Undecipherable e) {
        exception = e;
      }
    }

    @Override
    public String prescriptionContent() {
      if (exception != null) {
        throw exception;
      }
      return prescriptionContent;
    }
  }
}
