package be.recipe.api;

import be.recipe.api.executor.Executor;

// tag::class[]
public interface GetPrescriptionStatusResponse {
  // end::class[]
  // tag::methods[]
  Prescription.Status status();

  Executor executor();
  // end::methods[]

  class Simple implements GetPrescriptionStatusResponse {
    private Prescription.Status status;
    private Executor executor;

    public static Simple response() {
      return new Simple();
    }

    @Override
    public Prescription.Status status() {
      return status;
    }

    public Simple status(Prescription.Status status) {
      this.status = status;
      return this;
    }

    @Override
    public Executor executor() {
      return executor;
    }

    public Simple executor(Executor executor) {
      this.executor = executor;
      return this;
    }
  }
  // tag::class[]
}
// end::class[]
