package be.recipe.xjc.decorators;

import be.recipe.xjc.BackwardsCompatibleClientCodePlugin;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.outline.ClassOutline;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class AbstractTypeDecorator
    implements BackwardsCompatibleClientCodePlugin.Decorator {
  private final String expectedType;

  public AbstractTypeDecorator(String expectedType) {
    this.expectedType = expectedType;
  }

  @Override
  public void decorate(ClassOutline type) {
    if (type.getImplClass().name().equals(expectedType)
        || type.getImplClass().fullName().equals(expectedType)) doDecorate(type);
  }

  protected abstract void doDecorate(ClassOutline type);

  protected Stream<JDefinedClass> subtypes(JDefinedClass type) {
    return StreamSupport.stream(((Iterable<JDefinedClass>) type::classes).spliterator(), false);
  }
}
