package be.recipe.xjc.decorators;

import be.recipe.xjc.BackwardsCompatibleClientCodePlugin;
import com.sun.tools.xjc.outline.ClassOutline;
import javax.xml.bind.annotation.XmlRootElement;

public class XmlRootElementDecorator implements BackwardsCompatibleClientCodePlugin.Decorator {
  private final String namespace;

  public XmlRootElementDecorator(String namespace) {
    this.namespace = namespace;
  }

  @Override
  public void decorate(ClassOutline type) {
    if (type.getTarget()
        .getSchemaComponent()
        .getOwnerSchema()
        .getTargetNamespace()
        .equals(namespace))
      type.getImplClass().annotations().stream()
          .filter(it -> it.getAnnotationClass().name().equals("XmlRootElement"))
          .findFirst()
          .orElseGet(() -> type.getImplClass().annotate(XmlRootElement.class))
          .param("namespace", namespace);
  }
}
