package be.recipe.xjc;

import be.recipe.xjc.decorators.*;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.xml.sax.ErrorHandler;

public class BackwardsCompatibleClientCodePlugin extends Plugin {
  private final List<Decorator> decorators = new ArrayList<>();

  public BackwardsCompatibleClientCodePlugin() {
    Stream.of(
            new XmlRootElementDecorator("urn:be:fgov:ehealth:recipe:protocol:v4"),
            new XmlRootElementDecorator("http:/services.recipe.be/prescriber"),
            new XmlRootElementDecorator("http:/services.recipe.be/patient"),
            new XmlRootElementDecorator("http:/services.recipe.be/executor"),
            new PrescriptionSortedBy(),
            new ReservationSortedBy(),
            new ValidationReport(),
            new ListPrescriptionsResult(),
            new ListPrescriptionsParam(),
            new Properties(),
            new RuleMessage(),
            new ValidationWarnings(),
            new StatusType(),
            new ValidationPropertiesResult(),
            new PutRidsInProcessResult())
        .forEach(decorators::add);
  }

  @Override
  public String getOptionName() {
    return "Xrecipe-backwards-compatible-client-code";
  }

  @Override
  public String getUsage() {
    return "-" + getOptionName();
  }

  @Override
  public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
    outline.getClasses().forEach(type -> decorators.forEach(decorator -> decorator.decorate(type)));
    return true;
  }

  public interface Decorator {
    void decorate(ClassOutline type);
  }
}
