/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.xjc.decorators;

import be.recipe.xjc.decorators.AbstractTypeDecorator;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.outline.ClassOutline;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public abstract class AbstractGetterDecorator
extends AbstractTypeDecorator {
    private final Type type;

    public AbstractGetterDecorator(String expectedType, String from, String to, Type ... subtypes) {
        this(expectedType, subtypes);
        this.type.add(Type.Mapping.mapping(from, to));
    }

    public AbstractGetterDecorator(String expectedType, Type ... subtypes) {
        super(expectedType);
        this.type = Type.type(expectedType);
        Stream.of(subtypes).forEach(this.type::add);
    }

    @Override
    protected void doDecorate(ClassOutline outline) {
        this.decorate(outline.getImplClass(), this.type);
    }

    private void decorate(JDefinedClass containerType, Type type) {
        type.mappings().forEach(mapping -> this.generateGetter(containerType, (Type.Mapping)mapping));
        this.subtypes(containerType).forEach(subType -> type.subtypes().filter(it -> it.match((JClass)subType)).forEach(it -> this.decorate((JDefinedClass)subType, (Type)it)));
    }

    private void generateGetter(JDefinedClass type, Type.Mapping mapping) {
        JMethod targetMethod = type.getMethod(mapping.to(), new JType[0]);
        type.method(1, targetMethod.type(), mapping.from()).body()._return((JExpression)JExpr.invoke((JMethod)targetMethod));
    }

    public static class Type {
        private final List<Mapping> mappings = new ArrayList<Mapping>();
        private final List<Type> subtypes = new ArrayList<Type>();
        private final String type;

        public Type(String type) {
            this.type = type;
        }

        public static Type type(String type) {
            return new Type(type);
        }

        public boolean match(JClass type) {
            System.out.println("match(" + type.name() + ", " + this.type + ")");
            return type.name().equals(this.type);
        }

        public Type add(Mapping mapping) {
            this.mappings.add(mapping);
            return this;
        }

        public Stream<Mapping> mappings() {
            return this.mappings.stream();
        }

        public Stream<Type> subtypes() {
            return this.subtypes.stream();
        }

        public Type add(Type subtype) {
            this.subtypes.add(subtype);
            return this;
        }

        public static class Mapping {
            private final String from;
            private final String to;

            public static Mapping mapping(String from, String to) {
                return new Mapping(from, to);
            }

            private Mapping(String from, String to) {
                this.from = from;
                this.to = to;
            }

            public String to() {
                return this.to;
            }

            public String from() {
                return this.from;
            }
        }
    }
}

