package be.recipe.xjc.decorators;

import static be.recipe.xjc.decorators.AbstractGetterDecorator.Type.Mapping.mapping;
import static be.recipe.xjc.decorators.AbstractGetterDecorator.Type.type;
import static com.sun.codemodel.JMod.PUBLIC;

import be.recipe.xjc.decorators.AbstractGetterDecorator.Type.Mapping;
import com.sun.codemodel.*;
import com.sun.tools.xjc.outline.ClassOutline;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public abstract class AbstractGetterDecorator extends AbstractTypeDecorator {
  private final Type type;

  public AbstractGetterDecorator(String expectedType, String from, String to, Type... subtypes) {
    this(expectedType, subtypes);
    type.add(mapping(from, to));
  }

  public AbstractGetterDecorator(String expectedType, Type... subtypes) {
    super(expectedType);
    this.type = type(expectedType);
    Stream.of(subtypes).forEach(type::add);
  }

  @Override
  protected void doDecorate(ClassOutline outline) {
    decorate(outline.getImplClass(), type);
  }

  private void decorate(JDefinedClass containerType, Type type) {
    type.mappings().forEach(mapping -> generateGetter(containerType, mapping));
    subtypes(containerType)
        .forEach(
            subType ->
                type.subtypes()
                    .filter(it -> it.match(subType))
                    .forEach(it -> decorate(subType, it)));
  }

  private void generateGetter(JDefinedClass type, Mapping mapping) {
    JMethod targetMethod = type.getMethod(mapping.to(), new JType[0]);
    type.method(PUBLIC, targetMethod.type(), mapping.from())
        .body()
        ._return(JExpr.invoke(targetMethod));
  }

  public static class Type {
    private final List<Mapping> mappings = new ArrayList<>();
    private final List<Type> subtypes = new ArrayList<>();
    private final String type;

    public Type(String type) {
      this.type = type;
    }

    public static Type type(String type) {
      return new Type(type);
    }

    public boolean match(JClass type) {
      System.out.println("match(" + type.name() + ", " + this.type + ")");
      return type.name().equals(this.type);
    }

    public Type add(Mapping mapping) {
      mappings.add(mapping);
      return this;
    }

    public Stream<Mapping> mappings() {
      return mappings.stream();
    }

    public Stream<Type> subtypes() {
      return subtypes.stream();
    }

    public Type add(Type subtype) {
      subtypes.add(subtype);
      return this;
    }

    public static class Mapping {
      private final String from, to;

      public static Mapping mapping(String from, String to) {
        return new Mapping(from, to);
      }

      private Mapping(String from, String to) {
        this.from = from;
        this.to = to;
      }

      public String to() {
        return to;
      }

      public String from() {
        return from;
      }
    }
  }
}
