/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.common;

import be.recipe.api.crypto.Message;
import be.recipe.services.executor.PrescriptionWithSecurityToken;
import be.recipe.services.executor.TimestampedPrescription;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;

public class JAXBTimestampingContext
implements Message.Encrypted.Timestamped.Context {
    private static final JAXBContext ctx;

    public byte[] compact(byte[] it) {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Marshaller marshaller = ctx.createMarshaller();
            TimestampedPrescription timestamped = new TimestampedPrescription();
            PrescriptionWithSecurityToken prescription = new PrescriptionWithSecurityToken();
            prescription.setPrescriptionSealed(it);
            timestamped.setPrescriptionWithSecurityToken(prescription);
            marshaller.marshal((Object)timestamped, (OutputStream)out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        out.close();
        return byArray;
    }

    public byte[] encrypted(byte[] it) {
        byte[] byArray;
        ByteArrayInputStream input = new ByteArrayInputStream(it);
        try {
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            TimestampedPrescription prescription = (TimestampedPrescription)unmarshaller.unmarshal((InputStream)input);
            byArray = prescription.getPrescriptionWithSecurityToken().getPrescriptionSealed();
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnmarshalException e) {
                throw new Message.Encrypted.Timestamped.ExtractionFailed((Throwable)e);
            }
            catch (IOException | JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        input.close();
        return byArray;
    }

    static {
        try {
            ctx = JAXBContext.newInstance((Class[])new Class[]{TimestampedPrescription.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

